/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jooq;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jooq.ConnectionProvider;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.conf.MappedSchema;
import org.jooq.conf.RenderMapping;
import org.jooq.conf.Settings;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;

public class DBContextBuilder {
    String driverClass;
    String driverUrl;
    String username;
    String password;
    String host;
    String schemaName;
    DBType dbType;
    Integer port;
    HashMap<String, String> params = new HashMap();
    boolean useProxool = false;
    private int maxPoolSize = 20;
    private int maxStatementPerConnection = 20;
    private int checkoutTimeout = 2000;

    private String getAlias() {
        return String.valueOf(this.host) + "_" + this.schemaName;
    }

    public DSLContext build() {
        return this.buildFor(null);
    }

    public DSLContext buildFor(Schema schema) {
        if (this.driverUrl == null) {
            this.driverUrl = this.buildUrl();
        }
        if (this.driverClass == null) {
            this.driverClass = this.dbType.driverClass;
        }
        if (this.schemaName == null) {
            String[] strs = this.driverUrl.split("\\?")[0].split("/");
            this.schemaName = strs[strs.length - 1];
        }
        Settings settings = new Settings();
        if (schema != null && !schema.getName().equals(this.schemaName)) {
            settings = settings.withRenderMapping(new RenderMapping().withSchemata(new MappedSchema[]{new MappedSchema().withInput(schema.getName()).withOutput(this.schemaName)}));
        }
        if (this.useProxool) {
            this.initProxool();
            return DSL.using((ConnectionProvider)new ProxoolProvider(), (SQLDialect)this.dbType.dialect, (Settings)settings);
        }
        return DSL.using((ConnectionProvider)new C3P0Provider(this.initC3P0()), (SQLDialect)this.dbType.dialect, (Settings)settings);
    }

    public DBContextBuilder setMaxPoolSize(int size) {
        this.maxPoolSize = size;
        return this;
    }

    public DBContextBuilder setMaxStatementPerConnection(int size) {
        this.maxStatementPerConnection = size;
        return this;
    }

    public DBContextBuilder setCheckoutTimeout(int ms) {
        this.checkoutTimeout = ms;
        return this;
    }

    public ComboPooledDataSource initC3P0() {
        ComboPooledDataSource ds = new ComboPooledDataSource();
        ds.setJdbcUrl(this.driverUrl);
        ds.setUser(this.username);
        ds.setPassword(this.password);
        ds.setMaxStatements(180);
        ds.setMaxStatementsPerConnection(this.maxStatementPerConnection);
        ds.setMinPoolSize(5);
        ds.setIdleConnectionTestPeriod(60);
        ds.setPreferredTestQuery("select CURRENT_DATE");
        ds.setAcquireIncrement(5);
        ds.setMaxPoolSize(this.maxPoolSize);
        ds.setCheckoutTimeout(this.checkoutTimeout);
        return ds;
    }

    private void initProxool() {
        Properties info = new Properties();
        info.setProperty("proxool.maximum-connection-count", "20");
        info.setProperty("proxool.simultaneous-build-throttle", "20");
        info.setProperty("proxool.house-keeping-test-sql", "select CURRENT_DATE");
        info.setProperty("proxool.test-before-use:", "true");
        info.setProperty("user", this.username);
        info.setProperty("password", this.password);
        String alias = this.getAlias();
        String url = "proxool." + alias + ":" + this.driverClass + ":" + this.driverUrl;
        try {
            ProxoolFacade.registerConnectionPool((String)url, (Properties)info);
        }
        catch (ProxoolException e) {
            throw new RuntimeException("init database failed.", e);
        }
    }

    public HashMap<String, String> getParameters() {
        return this.params;
    }

    public DBContextBuilder setParameter(String key, String value) {
        this.params.put(key, value);
        return this;
    }

    public DBType getDbType() {
        return this.dbType;
    }

    public DBContextBuilder setDbType(DBType dbType) {
        this.dbType = dbType;
        return this;
    }

    public String buildUrl() {
        StringBuilder url = new StringBuilder();
        url.append("jdbc:").append(this.dbType.dialect.getNameLC()).append("://").append(this.host);
        if (this.port != null) {
            url.append(":").append(this.port);
        }
        if (this.schemaName != null) {
            url.append("/").append(this.schemaName);
        }
        if (!this.params.isEmpty()) {
            String join = "?";
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                url.append(join).append(entry.getKey()).append("=").append(entry.getValue());
                join = "&";
            }
        }
        return url.toString();
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public DBContextBuilder setDriverClass(String driverClass) {
        this.driverClass = driverClass;
        return this;
    }

    public String getDriverUrl() {
        return this.driverUrl;
    }

    public DBContextBuilder setDriverUrl(String driverUrl) {
        this.driverUrl = driverUrl;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public DBContextBuilder setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public DBContextBuilder setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public DBContextBuilder setHost(String host) {
        this.host = host;
        return this;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public DBContextBuilder setSchemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public DBContextBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public class C3P0Provider
    implements ConnectionProvider {
        Logger log = Logger.getLogger("dbpool");
        private ComboPooledDataSource c3p0;

        public C3P0Provider(ComboPooledDataSource c3p0) {
            this.c3p0 = c3p0;
        }

        public Connection acquire() throws DataAccessException {
            try {
                Connection c = this.c3p0.getConnection();
                int busy = this.c3p0.getNumBusyConnectionsAllUsers();
                int idle = this.c3p0.getNumIdleConnections();
                if (busy >= DBContextBuilder.this.maxPoolSize - 1) {
                    this.log.finer("acquired connection:" + c.toString() + " busy:" + busy + " idle:" + idle);
                }
                return c;
            }
            catch (SQLException e) {
                throw new DataAccessException(e.getMessage(), (Throwable)e);
            }
        }

        public void release(Connection connection) throws DataAccessException {
            try {
                connection.close();
                int busy = this.c3p0.getNumBusyConnectionsAllUsers();
                int idle = this.c3p0.getNumIdleConnections();
                if (busy >= DBContextBuilder.this.maxPoolSize - 1) {
                    this.log.finer("released connection:" + connection.toString() + " busy:" + busy + " idle:" + idle);
                }
            }
            catch (SQLException e) {
                throw new DataAccessException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static enum DBType {
        MYSQL(SQLDialect.MYSQL, "com.mysql.jdbc.Driver");

        private SQLDialect dialect;
        private String driverClass;

        private DBType(SQLDialect dialect, String driverClass) {
            this.dialect = dialect;
            this.driverClass = driverClass;
        }
    }

    public class ProxoolProvider
    implements ConnectionProvider {
        Logger log = Logger.getLogger("dbpool");

        public ProxoolProvider() {
            this.log.setLevel(Level.FINE);
        }

        public Connection acquire() throws DataAccessException {
            try {
                Connection c = DriverManager.getConnection("proxool." + DBContextBuilder.this.getAlias());
                return c;
            }
            catch (SQLException e) {
                throw new DataAccessException(e.getMessage(), (Throwable)e);
            }
        }

        public void release(Connection connection) throws DataAccessException {
            try {
                connection.close();
            }
            catch (SQLException e) {
                throw new DataAccessException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

