package com.jz.jar.join.repository;

import java.util.List;

import org.jooq.DSLContext;
import org.jooq.Table;
import org.jooq.TableRecord;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;

/**
 * @Title ICommonRepository
 * @Package com.jz.jar.join.repository
 * @author tangjunfeng
 * @date 2018年11月22日 上午11:40:40
 * @version V1.0
 */
public interface ICommonRepository<T extends Table<R>, R extends TableRecord<R>> {

	default public <E> int[] commomBatchInsertPojo(DSLContext ctx, T table, List<E> datas) {
		if (ArrayMapTools.isEmpty(datas))
			return null;
		List<R> records = Lists.newArrayList();
		datas.forEach(it -> records.add(ctx.newRecord(table, it)));
		return ctx.batchInsert(records).execute();
	}
}
