package com.jz.jar.join.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.join.Tables;
import com.jz.jooq.franchise.join.tables.pojos.JoinApply;

@Lazy
@Repository
public class JoinApplyRepository extends JoinBaseRepository {

	private static final com.jz.jooq.franchise.join.tables.JoinApply JA = Tables.JOIN_APPLY;

	public void save(JoinApply join) {
		joinCtx.insertInto(JA).set(joinCtx.newRecord(JA, join)).onDuplicateKeyIgnore().execute();
	}

	public boolean existJoinApply(String uid) {
		return joinCtx.fetchExists(JA, JA.APPLY_UID.eq(uid));
	}
}
