/*
 * Decompiled with CFR 0.152.
 */
package com.jz.gymchina.jar.resources.repository;

import com.jz.gymchina.jar.resources.repository.ResourceBaseRepository;
import com.jz.jooq.gymchina.resources.Tables;
import com.jz.jooq.gymchina.resources.tables.UserGroup;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.InsertValuesStep2;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class UserGroupRepository
extends ResourceBaseRepository {
    private static UserGroup UG = Tables.USER_GROUP;

    public List<String> getGroupsForUser(String uid) {
        return this.resourcesCtx.select((SelectField)UserGroupRepository.UG.GID).from((TableLike)UG).where(new Condition[]{UserGroupRepository.UG.UID.eq((Object)uid)}).fetchInto(String.class);
    }

    public void clearGroups(String uid) {
        this.resourcesCtx.deleteFrom((Table)UG).where(new Condition[]{UserGroupRepository.UG.UID.eq((Object)uid)}).execute();
    }

    public void refreshGroups(String uid, Collection<String> gids) {
        InsertValuesStep2 values = this.resourcesCtx.insertInto((Table)UG, (Field)UserGroupRepository.UG.UID, (Field)UserGroupRepository.UG.GID);
        for (String gid : gids) {
            values = values.values((Object)uid, (Object)gid);
        }
        values.onDuplicateKeyIgnore().execute();
    }
}

