/*
 * Decompiled with CFR 0.152.
 */
package com.jz.gymchina.jar.resources.repository;

import com.jz.gymchina.jar.resources.repository.ResourceBaseRepository;
import com.jz.jooq.gymchina.resources.Tables;
import com.jz.jooq.gymchina.resources.tables.pojos.GymUserInfo;
import com.jz.jooq.gymchina.resources.tables.records.GymUserInfoRecord;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class GymUserInfoRepository
extends ResourceBaseRepository {
    private static com.jz.jooq.gymchina.resources.tables.GymUserInfo UI = Tables.GYM_USER_INFO;

    public boolean existUsername(String username) {
        return this.resourcesCtx.fetchExists((Table)UI, GymUserInfoRepository.UI.USERNAME.eq((Object)username));
    }

    public GymUserInfo getUserForLogin(String username, String password) {
        return (GymUserInfo)this.resourcesCtx.select((SelectField)GymUserInfoRepository.UI.UID, (SelectField)GymUserInfoRepository.UI.USERNAME, (SelectField)GymUserInfoRepository.UI.NICKNAME, (SelectField)GymUserInfoRepository.UI.ENABLE).from((TableLike)UI).where(new Condition[]{GymUserInfoRepository.UI.USERNAME.eq((Object)username).and(GymUserInfoRepository.UI.PASSWORD.eq((Object)password))}).fetchAnyInto(GymUserInfo.class);
    }

    public void addUserInfo(String uid, String username, String password, String nickname, String email) {
        GymUserInfoRecord userInfo = new GymUserInfoRecord();
        userInfo.setUid(uid);
        userInfo.setUsername(username);
        userInfo.setPassword(password);
        userInfo.setNickname(nickname);
        userInfo.setEmail(email);
        userInfo.setIsAdmin(Integer.valueOf(0));
        userInfo.setLastUpdate(Long.valueOf(System.currentTimeMillis()));
        userInfo.setEnable(Integer.valueOf(1));
        this.resourcesCtx.insertInto((Table)UI).set((Record)userInfo).execute();
    }

    public void updatePassword(String uid, String password) {
        this.resourcesCtx.update((Table)UI).set((Field)GymUserInfoRepository.UI.PASSWORD, (Object)password).set((Field)GymUserInfoRepository.UI.LAST_UPDATE, (Object)System.currentTimeMillis()).where(new Condition[]{GymUserInfoRepository.UI.UID.eq((Object)uid)}).execute();
    }

    public void updateUserEnableInfo(String uid, int enable) {
        this.resourcesCtx.update((Table)UI).set((Field)GymUserInfoRepository.UI.ENABLE, (Object)enable).set((Field)GymUserInfoRepository.UI.LAST_UPDATE, (Object)System.currentTimeMillis()).where(new Condition[]{GymUserInfoRepository.UI.UID.eq((Object)uid)}).execute();
    }

    public boolean isAdmin(String uid) {
        return this.resourcesCtx.fetchExists((Table)UI, GymUserInfoRepository.UI.UID.eq((Object)uid).and(GymUserInfoRepository.UI.ENABLE.eq((Object)1)).and(GymUserInfoRepository.UI.IS_ADMIN.eq((Object)1)));
    }

    public List<String> getForbiddenUsers() {
        return this.resourcesCtx.select((SelectField)GymUserInfoRepository.UI.UID).from((TableLike)UI).where(new Condition[]{GymUserInfoRepository.UI.ENABLE.eq((Object)0)}).fetchInto(String.class);
    }

    public List<GymUserInfo> getUsers() {
        return this.resourcesCtx.select((SelectField)GymUserInfoRepository.UI.UID, (SelectField)GymUserInfoRepository.UI.USERNAME, (SelectField)GymUserInfoRepository.UI.NICKNAME, (SelectField)GymUserInfoRepository.UI.ENABLE).from((TableLike)UI).orderBy(GymUserInfoRepository.UI.LAST_UPDATE.desc()).fetchInto(GymUserInfo.class);
    }
}

