/*
 * Decompiled with CFR 0.152.
 */
package com.jz.gymchina.jar.resources.repository;

import com.google.common.collect.Lists;
import com.jz.gymchina.jar.resources.enums.ResourceEnum;
import com.jz.gymchina.jar.resources.repository.ResourceBaseRepository;
import com.jz.jooq.gymchina.resources.Tables;
import com.jz.jooq.gymchina.resources.tables.GymFile;
import com.jz.jooq.gymchina.resources.tables.records.GymFileRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class FileRepository
extends ResourceBaseRepository {
    private static GymFile FILE = Tables.GYM_FILE;

    public Condition getWhereCondition(String dirId) {
        return FileRepository.FILE.DIR_ID.eq((Object)dirId).and(FileRepository.FILE.STATUS.eq((Object)ResourceEnum.online.name()));
    }

    public int countFilesForDirectory(String dirId) {
        return this.resourcesCtx.fetchCount((Table)FILE, this.getWhereCondition(dirId));
    }

    public boolean existFile(String fileId) {
        return this.resourcesCtx.fetchExists((Table)FILE, FileRepository.FILE.ID.eq((Object)fileId).and(FileRepository.FILE.STATUS.eq((Object)ResourceEnum.online.name())));
    }

    public int countExistFile(Collection<String> fileIds) {
        return this.resourcesCtx.fetchCount((Table)FILE, FileRepository.FILE.ID.in(fileIds).and(FileRepository.FILE.STATUS.eq((Object)ResourceEnum.online.name())));
    }

    public List<com.jz.jooq.gymchina.resources.tables.pojos.GymFile> getFilesForDirectory(String dirId) {
        return this.resourcesCtx.select((SelectField)FileRepository.FILE.ID, (SelectField)FileRepository.FILE.NAME, (SelectField)FileRepository.FILE.TYPE, (SelectField)FileRepository.FILE.SIZE, (SelectField)FileRepository.FILE.LAST_UPDATE).from((TableLike)FILE).where(new Condition[]{this.getWhereCondition(dirId)}).orderBy(FileRepository.FILE.NAME.asc()).fetchInto(com.jz.jooq.gymchina.resources.tables.pojos.GymFile.class);
    }

    public List<com.jz.jooq.gymchina.resources.tables.pojos.GymFile> getFilesForDirectory(Collection<String> dirIds) {
        return this.resourcesCtx.selectFrom((Table)FILE).where(new Condition[]{FileRepository.FILE.DIR_ID.in(dirIds).and(FileRepository.FILE.STATUS.eq((Object)ResourceEnum.online.name()))}).fetchInto(com.jz.jooq.gymchina.resources.tables.pojos.GymFile.class);
    }

    public List<com.jz.jooq.gymchina.resources.tables.pojos.GymFile> getFiles(Collection<String> fileIds) {
        return this.resourcesCtx.selectFrom((Table)FILE).where(new Condition[]{FileRepository.FILE.ID.in(fileIds).and(FileRepository.FILE.STATUS.eq((Object)ResourceEnum.online.name()))}).fetchInto(com.jz.jooq.gymchina.resources.tables.pojos.GymFile.class);
    }

    public String getFileDirectory(String fileId) {
        return (String)this.resourcesCtx.select((SelectField)FileRepository.FILE.DIR_ID).from((TableLike)FILE).where(new Condition[]{FileRepository.FILE.ID.eq((Object)fileId)}).fetchAnyInto(String.class);
    }

    public void updateFileName(String fileId, String name, String uid) {
        this.resourcesCtx.update((Table)FILE).set((Field)FileRepository.FILE.NAME, (Object)name).set((Field)FileRepository.FILE.UID, (Object)uid).set((Field)FileRepository.FILE.LAST_UPDATE, (Object)System.currentTimeMillis()).where(new Condition[]{FileRepository.FILE.ID.eq((Object)fileId)}).execute();
    }

    public void deleteFile(String fileId, String uid) {
        this.resourcesCtx.update((Table)FILE).set((Field)FileRepository.FILE.STATUS, (Object)ResourceEnum.delete.name()).set((Field)FileRepository.FILE.UID, (Object)uid).set((Field)FileRepository.FILE.LAST_UPDATE, (Object)System.currentTimeMillis()).where(new Condition[]{FileRepository.FILE.ID.eq((Object)fileId)}).execute();
    }

    public void addFile(String fileId, String fileName, String dirId, String ext, String ossUrl, long size, String uid) {
        long timeMillis = System.currentTimeMillis();
        GymFileRecord file = new GymFileRecord();
        file.setId(fileId);
        file.setName(fileName);
        file.setDirId(dirId);
        file.setType(ext);
        file.setOssUrl(ossUrl);
        file.setSize(Long.valueOf(size));
        file.setStatus(ResourceEnum.online.name());
        file.setUid(uid);
        file.setCreateTime(Long.valueOf(timeMillis));
        file.setLastUpdate(Long.valueOf(timeMillis));
        this.resourcesCtx.insertInto((Table)FILE).set((Record)file).execute();
    }

    public void batchInsertFiles(Collection<com.jz.jooq.gymchina.resources.tables.pojos.GymFile> files) {
        ArrayList records = Lists.newArrayList();
        for (com.jz.jooq.gymchina.resources.tables.pojos.GymFile file : files) {
            records.add(this.resourcesCtx.newRecord((Table)FILE, (Object)file));
        }
        this.resourcesCtx.batchInsert((Collection)records).execute();
    }
}

