/*
 * Decompiled with CFR 0.152.
 */
package com.jz.gymchina.jar.resources.cache.ram;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.gymchina.jar.resources.common.GymchinaThreadPool;
import com.jz.gymchina.jar.resources.service.GroupDirectoryService;
import com.jz.jooq.gymchina.resources.tables.pojos.GroupDir;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Lazy
@Component
public class RAMGroupDirectoryCache {
    @Autowired
    private GroupDirectoryService groupDirectoryService;
    private static final Map<String, List<String>> group2Directories = Maps.newHashMap();
    private static final Map<String, List<String>> directory2Groups = Maps.newHashMap();

    public void syncRefreshCacheInfo() {
        GymchinaThreadPool.defaultThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                RAMGroupDirectoryCache.this.refreshCacheInfo();
            }
        });
    }

    @PostConstruct
    public void refreshCacheInfo() {
        List<GroupDir> groupDirectories = this.groupDirectoryService.getGroupDirectories();
        if (ArrayMapTools.isEmpty(groupDirectories)) {
            group2Directories.clear();
            directory2Groups.clear();
            return;
        }
        HashMap tmpGroup2Directories = Maps.newHashMap();
        HashMap tmpDirectory2Groups = Maps.newHashMap();
        for (GroupDir gd : groupDirectories) {
            if (!tmpGroup2Directories.containsKey(gd.getGid())) {
                tmpGroup2Directories.put(gd.getGid(), Lists.newArrayList());
            }
            ((List)tmpGroup2Directories.get(gd.getGid())).add(gd.getDirId());
            if (!tmpDirectory2Groups.containsKey(gd.getDirId())) {
                tmpDirectory2Groups.put(gd.getDirId(), Lists.newArrayList());
            }
            ((List)tmpDirectory2Groups.get(gd.getDirId())).add(gd.getGid());
        }
        group2Directories.clear();
        group2Directories.putAll(tmpGroup2Directories);
        directory2Groups.clear();
        directory2Groups.putAll(tmpDirectory2Groups);
    }

    public Set<String> getDirectoriesForGroups(Collection<String> groups) {
        HashSet directories = Sets.newHashSet();
        groups.forEach(it -> {
            if (!group2Directories.containsKey(it)) {
                return;
            }
            directories.addAll((Collection)group2Directories.get(it));
        });
        return directories;
    }
}

