package com.jz.gymchina.jar.resources.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.gymchina.resources.Tables;
import com.jz.jooq.gymchina.resources.tables.pojos.GymUserInfo;
import com.jz.jooq.gymchina.resources.tables.records.GymUserInfoRecord;

@Lazy
@Repository
public class GymUserInfoRepository extends ResourceBaseRepository {

	private static com.jz.jooq.gymchina.resources.tables.GymUserInfo UI = Tables.GYM_USER_INFO;

	public boolean existUsername(String username) {
		return resourcesCtx.fetchExists(UI, UI.USERNAME.eq(username));
	}

	public GymUserInfo getUserForLogin(String username, String password) {
		return resourcesCtx.select(UI.UID, UI.USERNAME, UI.NICKNAME, UI.ENABLE).from(UI)
				.where(UI.USERNAME.eq(username).and(UI.PASSWORD.eq(password))).fetchAnyInto(GymUserInfo.class);
	}

	public void addUserInfo(String uid, String username, String password, String nickname, String email) {
		GymUserInfoRecord userInfo = new GymUserInfoRecord();
		userInfo.setUid(uid);
		userInfo.setUsername(username);
		userInfo.setPassword(password);
		userInfo.setNickname(nickname);
		userInfo.setEmail(email);
		userInfo.setIsAdmin(0); // 非管理员
		userInfo.setLastUpdate(System.currentTimeMillis());
		userInfo.setEnable(1); // 有效的账户
		resourcesCtx.insertInto(UI).set(userInfo).execute();
	}

	public void updatePassword(String uid, String password) {
		resourcesCtx.update(UI).set(UI.PASSWORD, password).set(UI.LAST_UPDATE, System.currentTimeMillis())
				.where(UI.UID.eq(uid)).execute();
	}

	public void forbiddenUserInfo(String uid) {
		resourcesCtx.update(UI).set(UI.ENABLE, 0).set(UI.LAST_UPDATE, System.currentTimeMillis()).where(UI.UID.eq(uid))
				.execute();
	}

	public boolean isAdmin(String uid) {
		return resourcesCtx.fetchExists(UI, UI.UID.eq(uid).and(UI.ENABLE.eq(1)).and(UI.IS_ADMIN.eq(1)));
	}

	public List<String> getForbiddenUsers() {
		return resourcesCtx.select(UI.UID).from(UI).where(UI.ENABLE.eq(0)).fetchInto(String.class);
	}

	public List<GymUserInfo> getUsers() {
		return resourcesCtx.select(UI.UID, UI.USERNAME, UI.NICKNAME, UI.ENABLE).from(UI).orderBy(UI.LAST_UPDATE.desc())
				.fetchInto(GymUserInfo.class);
	}
}
