/*
 * Decompiled with CFR 0.152.
 */
package com.jz.gymchina.jar.resources.cache.ram;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import com.jz.gymchina.jar.resources.service.DirectoryService;
import com.jz.jooq.gymchina.resources.tables.pojos.GymDirectory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Lazy
@Component
public class RAMDirectoryCache {
    @Autowired
    private DirectoryService directoryService;
    private static final List<String> root = Lists.newArrayList();
    private static final Map<String, List<String>> parent2Children = Maps.newHashMap();
    private static final Map<String, String> directoryId2ParentDirectoryId = Maps.newHashMap();

    private void clearCache() {
        root.clear();
        parent2Children.clear();
        directoryId2ParentDirectoryId.clear();
    }

    private <T> void clearPut(List<T> cache, List<T> temp) {
        cache.clear();
        cache.addAll(temp);
    }

    private <K, V> void clearPut(Map<K, V> cache, Map<K, V> temp) {
        cache.clear();
        cache.putAll(temp);
    }

    @PostConstruct
    public void refreshCacheInfo() {
        List<GymDirectory> directories = this.directoryService.getOnlineDirectories();
        if (ArrayMapTools.isEmpty(directories)) {
            this.clearCache();
            return;
        }
        ArrayList tmpRoot = Lists.newArrayList();
        HashMap tmpParent2Children = Maps.newHashMap();
        HashMap tmpId2ParentId = Maps.newHashMap();
        for (GymDirectory directory : directories) {
            if (StringTools.isEmptyAndBlank((String)directory.getParentId())) {
                tmpRoot.add(directory.getId());
            } else {
                if (!tmpParent2Children.containsKey(directory.getParentId())) {
                    tmpParent2Children.put(directory.getParentId(), Lists.newArrayList());
                }
                ((List)tmpParent2Children.get(directory.getParentId())).add(directory.getId());
            }
            tmpId2ParentId.put(directory.getId(), directory.getParentId());
        }
        this.clearPut(root, tmpRoot);
        this.clearPut(parent2Children, tmpParent2Children);
        this.clearPut(directoryId2ParentDirectoryId, tmpId2ParentId);
    }

    public List<String> getPosterities(String directoryId) {
        ArrayList posterities = Lists.newArrayList();
        this.getPosterities(directoryId, posterities);
        return posterities;
    }

    private void getPosterities(String directoryId, List<String> posterities) {
        if (!parent2Children.containsKey(directoryId)) {
            return;
        }
        List<String> children = parent2Children.get(directoryId);
        posterities.addAll(children);
        children.forEach(child -> this.getPosterities((String)child, posterities));
    }

    public List<String> getAncestors(String directoryId) {
        ArrayList ancestors = Lists.newArrayList();
        this.getAncestors(directoryId, ancestors);
        return ancestors;
    }

    private void getAncestors(String directoryId, List<String> ancestors) {
        if (!directoryId2ParentDirectoryId.containsKey(directoryId)) {
            return;
        }
        String parentDirectoryId = directoryId2ParentDirectoryId.get(directoryId);
        if (StringTools.isEmptyAndBlank((String)parentDirectoryId)) {
            return;
        }
        ancestors.add(parentDirectoryId);
        this.getAncestors(parentDirectoryId, ancestors);
    }

    public String getRoot(String directoryId) {
        if (!directoryId2ParentDirectoryId.containsKey(directoryId)) {
            return directoryId;
        }
        String parentId = directoryId2ParentDirectoryId.get(directoryId);
        if (StringTools.isEmpty((CharSequence)parentId)) {
            return directoryId;
        }
        return this.getRoot(parentId);
    }
}

