/*
 * Decompiled with CFR 0.152.
 */
package com.jz.gymchina.jar.resources.repository;

import com.google.common.collect.Lists;
import com.jz.gymchina.jar.resources.enums.ResourceEnum;
import com.jz.gymchina.jar.resources.repository.ResourceBaseRepository;
import com.jz.jooq.gymchina.resources.Tables;
import com.jz.jooq.gymchina.resources.tables.GymDirectory;
import com.jz.jooq.gymchina.resources.tables.records.GymDirectoryRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class DirectoryRepository
extends ResourceBaseRepository {
    private static GymDirectory DIR = Tables.GYM_DIRECTORY;

    public List<com.jz.jooq.gymchina.resources.tables.pojos.GymDirectory> getOnlineDirectories(boolean isShowName) {
        ArrayList fields = Lists.newArrayList((Object[])new TableField[]{DirectoryRepository.DIR.ID, DirectoryRepository.DIR.PARENT_ID});
        if (isShowName) {
            fields.add(DirectoryRepository.DIR.NAME);
        }
        return this.resourcesCtx.select((Collection)fields).from((TableLike)DIR).where(new Condition[]{DirectoryRepository.DIR.STATUS.eq((Object)ResourceEnum.online.name())}).orderBy(DirectoryRepository.DIR.NAME.asc()).fetchInto(com.jz.jooq.gymchina.resources.tables.pojos.GymDirectory.class);
    }

    private Condition getWhereCondition(String dirId) {
        Condition condition = DirectoryRepository.DIR.STATUS.eq((Object)ResourceEnum.online.name());
        if (null == dirId) {
            return condition.and(DirectoryRepository.DIR.RANK_IDX.eq((Object)1));
        }
        return condition.and(DirectoryRepository.DIR.PARENT_ID.eq((Object)dirId));
    }

    public int countChildrenDirectories(String dirId) {
        return this.resourcesCtx.fetchCount((Table)DIR, this.getWhereCondition(dirId));
    }

    public List<com.jz.jooq.gymchina.resources.tables.pojos.GymDirectory> getChildrenDirectories(String dirId) {
        return this.resourcesCtx.select((SelectField)DirectoryRepository.DIR.ID, (SelectField)DirectoryRepository.DIR.NAME, (SelectField)DirectoryRepository.DIR.LAST_UPDATE).from((TableLike)DIR).where(new Condition[]{this.getWhereCondition(dirId)}).orderBy(DirectoryRepository.DIR.NAME.asc()).fetchInto(com.jz.jooq.gymchina.resources.tables.pojos.GymDirectory.class);
    }

    public boolean existDirectory(String dirId) {
        return this.resourcesCtx.fetchExists((Table)DIR, DirectoryRepository.DIR.ID.eq((Object)dirId).and(DirectoryRepository.DIR.STATUS.eq((Object)ResourceEnum.online.name())));
    }

    public int countExistDirectory(Collection<String> dirIds) {
        return this.resourcesCtx.fetchCount((Table)DIR, DirectoryRepository.DIR.ID.in(dirIds).and(DirectoryRepository.DIR.STATUS.eq((Object)ResourceEnum.online.name())));
    }

    public com.jz.jooq.gymchina.resources.tables.pojos.GymDirectory getDirectory(String dirId) {
        return (com.jz.jooq.gymchina.resources.tables.pojos.GymDirectory)this.resourcesCtx.selectFrom((Table)DIR).where(new Condition[]{DirectoryRepository.DIR.ID.eq((Object)dirId).and(DirectoryRepository.DIR.STATUS.eq((Object)ResourceEnum.online.name()))}).fetchAnyInto(com.jz.jooq.gymchina.resources.tables.pojos.GymDirectory.class);
    }

    public List<com.jz.jooq.gymchina.resources.tables.pojos.GymDirectory> getDirectories(Collection<String> dirIds) {
        return this.resourcesCtx.selectFrom((Table)DIR).where(new Condition[]{DirectoryRepository.DIR.ID.in(dirIds).and(DirectoryRepository.DIR.STATUS.eq((Object)ResourceEnum.online.name()))}).orderBy(DirectoryRepository.DIR.NAME.asc()).fetchInto(com.jz.jooq.gymchina.resources.tables.pojos.GymDirectory.class);
    }

    public Integer getDirectoryRank(String dirId) {
        return (Integer)this.resourcesCtx.select((SelectField)DirectoryRepository.DIR.RANK_IDX).from((TableLike)DIR).where(new Condition[]{DirectoryRepository.DIR.ID.eq((Object)dirId).and(DirectoryRepository.DIR.STATUS.eq((Object)ResourceEnum.online.name()))}).fetchAnyInto(Integer.class);
    }

    public void addDirectory(String dirId, String name, com.jz.jooq.gymchina.resources.tables.pojos.GymDirectory parentDir, String uid) {
        GymDirectoryRecord directory = new GymDirectoryRecord();
        directory.setId(dirId);
        directory.setName(name);
        if (null == parentDir) {
            directory.setRankIdx(Integer.valueOf(1));
            directory.setRootId(dirId);
        } else {
            directory.setParentId(parentDir.getId());
            directory.setRankIdx(Integer.valueOf(parentDir.getRankIdx() + 1));
            directory.setRootId(parentDir.getRootId());
        }
        directory.setStatus(ResourceEnum.online.name());
        directory.setUid(uid);
        long timeMillis = System.currentTimeMillis();
        directory.setCreateTime(Long.valueOf(timeMillis));
        directory.setLastUpdate(Long.valueOf(timeMillis));
        this.resourcesCtx.insertInto((Table)DIR).set((Record)directory).execute();
    }

    public void updateDirectoryName(String dirId, String name, String uid) {
        this.resourcesCtx.update((Table)DIR).set((Field)DirectoryRepository.DIR.NAME, (Object)name).set((Field)DirectoryRepository.DIR.UID, (Object)uid).set((Field)DirectoryRepository.DIR.LAST_UPDATE, (Object)System.currentTimeMillis()).where(new Condition[]{DirectoryRepository.DIR.ID.eq((Object)dirId)}).execute();
    }

    public void deleteDirectory(String dirId, String uid) {
        this.resourcesCtx.update((Table)DIR).set((Field)DirectoryRepository.DIR.STATUS, (Object)ResourceEnum.delete.name()).set((Field)DirectoryRepository.DIR.UID, (Object)uid).set((Field)DirectoryRepository.DIR.LAST_UPDATE, (Object)System.currentTimeMillis()).where(new Condition[]{DirectoryRepository.DIR.ID.eq((Object)dirId)}).execute();
    }

    public void batchInsertDirectories(Collection<com.jz.jooq.gymchina.resources.tables.pojos.GymDirectory> directories) {
        ArrayList records = Lists.newArrayList();
        for (com.jz.jooq.gymchina.resources.tables.pojos.GymDirectory directory : directories) {
            records.add(this.resourcesCtx.newRecord((Table)DIR, (Object)directory));
        }
        this.resourcesCtx.batchInsert((Collection)records).execute();
    }

    public String getDirectoryRoot(String dirId) {
        return (String)this.resourcesCtx.select((SelectField)DirectoryRepository.DIR.ROOT_ID).from((TableLike)DIR).where(new Condition[]{DirectoryRepository.DIR.ID.eq((Object)dirId).and(DirectoryRepository.DIR.STATUS.eq((Object)ResourceEnum.online.name()))}).fetchAnyInto(String.class);
    }

    public List<com.jz.jooq.gymchina.resources.tables.pojos.GymDirectory> getDirectoryRoot(Collection<String> dirIds) {
        return this.resourcesCtx.select((SelectField)DirectoryRepository.DIR.ID, (SelectField)DirectoryRepository.DIR.ROOT_ID).from((TableLike)DIR).where(new Condition[]{DirectoryRepository.DIR.ID.in(dirIds).and(DirectoryRepository.DIR.STATUS.eq((Object)ResourceEnum.online.name()))}).fetchInto(com.jz.jooq.gymchina.resources.tables.pojos.GymDirectory.class);
    }
}

