/*
 * Decompiled with CFR 0.152.
 */
package com.jz.gymchina.jar.resources.cache.ram;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import com.jz.gymchina.jar.resources.service.DirectoryService;
import com.jz.jooq.gymchina.resources.tables.pojos.GymDirectory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Lazy
@Component
public class RAMDirectoryCache {
    @Autowired
    private DirectoryService directoryService;
    private static final List<String> roots = Lists.newArrayList();
    private static final Map<String, List<String>> parentDirId2ChildrenId = Maps.newHashMap();
    private static final Map<String, String> dirId2ParentId = Maps.newHashMap();
    private static final Map<String, String> dirId2Name = Maps.newHashMap();

    private void clearCache() {
        roots.clear();
        parentDirId2ChildrenId.clear();
        dirId2ParentId.clear();
    }

    private <T> void clearPut(List<T> cache, List<T> temp) {
        cache.clear();
        if (ArrayMapTools.isNotEmpty(temp)) {
            cache.addAll(temp);
        }
    }

    private <K, V> void clearPut(Map<K, V> cache, Map<K, V> temp) {
        cache.clear();
        if (ArrayMapTools.isNotEmpty(temp)) {
            cache.putAll(temp);
        }
    }

    @PostConstruct
    public void refreshCacheInfo() {
        List<GymDirectory> directories = this.directoryService.getOnlineDirectories(true);
        if (ArrayMapTools.isEmpty(directories)) {
            this.clearCache();
            return;
        }
        ArrayList tmpRoot = Lists.newArrayList();
        HashMap tmpParent2Children = Maps.newHashMap();
        HashMap tmpId2ParentId = Maps.newHashMap();
        for (GymDirectory directory : directories) {
            dirId2Name.put(directory.getId(), directory.getName());
            if (StringTools.isEmptyAndBlank((String)directory.getParentId())) {
                tmpRoot.add(directory.getId());
            } else {
                if (!tmpParent2Children.containsKey(directory.getParentId())) {
                    tmpParent2Children.put(directory.getParentId(), Lists.newArrayList());
                }
                ((List)tmpParent2Children.get(directory.getParentId())).add(directory.getId());
            }
            tmpId2ParentId.put(directory.getId(), directory.getParentId());
        }
        this.clearPut(roots, tmpRoot);
        this.clearPut(parentDirId2ChildrenId, tmpParent2Children);
        this.clearPut(dirId2ParentId, tmpId2ParentId);
    }

    public List<String> getPosterities(String directoryId) {
        ArrayList posterities = Lists.newArrayList();
        this.getPosterities(directoryId, posterities);
        return posterities;
    }

    private void getPosterities(String directoryId, List<String> posterities) {
        if (!parentDirId2ChildrenId.containsKey(directoryId)) {
            return;
        }
        List<String> children = parentDirId2ChildrenId.get(directoryId);
        posterities.addAll(children);
        children.forEach(child -> this.getPosterities((String)child, posterities));
    }

    public List<String> getChildren(String directoryId) {
        if (!parentDirId2ChildrenId.containsKey(directoryId)) {
            return null;
        }
        return Lists.newArrayList((Iterable)parentDirId2ChildrenId.get(directoryId));
    }

    public List<String> getAncestors(String directoryId, boolean isJoinSelf) {
        ArrayList ancestors = Lists.newArrayList();
        if (isJoinSelf) {
            ancestors.add(directoryId);
        }
        this.getAncestors(directoryId, ancestors);
        return ancestors;
    }

    private void getAncestors(String directoryId, List<String> ancestors) {
        if (!dirId2ParentId.containsKey(directoryId)) {
            return;
        }
        String parentDirectoryId = dirId2ParentId.get(directoryId);
        if (StringTools.isEmptyAndBlank((String)parentDirectoryId)) {
            return;
        }
        ancestors.add(parentDirectoryId);
        this.getAncestors(parentDirectoryId, ancestors);
    }

    public List<String> getRoots() {
        return Lists.newArrayList(roots);
    }

    public String getDirectoryName(String directoryId) {
        return dirId2Name.get(directoryId);
    }

    public boolean isHaveChildren(String directoryId) {
        return parentDirId2ChildrenId.containsKey(directoryId);
    }
}

