package com.jz.jar.franchise.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.Contract;
import com.jz.jooq.franchise.tables.pojos.ContractDetail;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class ContractRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.Contract C = Tables.CONTRACT;
	private static final com.jz.jooq.franchise.tables.ContractDetail CD = Tables.CONTRACT_DETAIL;

	public Contract getContract(String contractId, String schoolId) {
		return franchiseCtx.selectFrom(C).where(C.CONTRACT_ID.eq(contractId).and(C.SCHOOL_ID.eq(schoolId)))
				.fetchAnyInto(Contract.class);
	}

	public Contract getContract(String contractId) {
		return franchiseCtx.selectFrom(C).where(C.CONTRACT_ID.eq(contractId)).fetchAnyInto(Contract.class);
	}

	public ContractDetail getContractDetail(String contractId, String schoolId) {
		return franchiseCtx.selectFrom(CD).where(CD.CONTRACT_ID.eq(contractId).and(CD.SCHOOL_ID.eq(schoolId)))
				.fetchAnyInto(ContractDetail.class);
	}

	public List<Contract> getUserContractList(String puid) {
		return franchiseCtx.selectFrom(C).where(C.PUID.eq(puid).and(C.STATUS.eq(1))).orderBy(C.PAY_TIME.desc())
				.fetchInto(Contract.class);
	}
	
	public boolean isHaveContract(String puid) {
		return franchiseCtx.fetchExists(C, C.PUID.eq(puid).and(C.STATUS.eq(1)));
	}
	
	public Contract getSimpleContract(String contractId) {
		return franchiseCtx.select(C.START_TIME).from(C).where(C.CONTRACT_ID.eq(contractId))
				.fetchAnyInto(Contract.class);
	}
}
