/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.CoursePackRepository;
import com.jz.jar.franchise.service.SchoolService;
import com.jz.jar.franchise.wrapper.CoursePackWrapper;
import com.jz.jooq.franchise.tables.pojos.CoursePackHo;
import com.jz.jooq.franchise.tables.pojos.CoursePackHoPrice;
import com.jz.jooq.franchise.tables.pojos.CoursePackSchool;
import com.jz.jooq.franchise.tables.pojos.School;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class CoursePackService {
    @Autowired
    private CoursePackRepository coursePackRepository;
    @Autowired
    private SchoolService schoolService;

    public List<CoursePackWrapper> getEnableSchoolPacks(String uid, String schoolId) {
        List<CoursePackSchool> schoolPacks;
        School school = this.schoolService.getSchool(schoolId);
        if (school == null) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        HashSet disableHoSet = Sets.newHashSet(this.coursePackRepository.getHoDisable(schoolId));
        List<CoursePackHo> hoPacks = this.coursePackRepository.getAllCoursePackHo(school.getBrandId());
        if (ArrayMapTools.isNotEmpty(hoPacks)) {
            hoPacks.forEach(it -> {
                if (!disableHoSet.contains(it.getCoursePackId())) {
                    list.add(CoursePackWrapper.ofMeta(it));
                }
            });
        }
        if (ArrayMapTools.isNotEmpty(schoolPacks = this.coursePackRepository.getEnablePackSchool(schoolId))) {
            schoolPacks.forEach(it -> list.add(CoursePackWrapper.ofMeta(it)));
        }
        return list;
    }

    public List<CoursePackWrapper> getSchoolPacksWithTotalInfos(String uid, String schoolId) {
        List<CoursePackSchool> schoolPacks;
        School school = this.schoolService.getSchool(schoolId);
        if (school == null) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        List<CoursePackHo> hoPacks = this.coursePackRepository.getAllCoursePackHo(school.getBrandId());
        if (ArrayMapTools.isNotEmpty(hoPacks)) {
            hoPacks.forEach(it -> list.add(CoursePackWrapper.ofHo(it)));
        }
        if (ArrayMapTools.isNotEmpty(schoolPacks = this.coursePackRepository.getPackSchool(schoolId))) {
            schoolPacks.forEach(it -> list.add(CoursePackWrapper.ofSchool(it)));
        }
        return list;
    }

    public List<CoursePackWrapper> getEnableSchoolPacksWithPrice(String brandId, String schoolId, int cityLevel) {
        List<CoursePackSchool> schoolPacks;
        ArrayList list = Lists.newArrayList();
        List<CoursePackHo> hoPacks = this.coursePackRepository.getAllCoursePackHo(brandId);
        HashSet disableHoSet = Sets.newHashSet(this.coursePackRepository.getHoDisable(schoolId));
        if (ArrayMapTools.isNotEmpty(hoPacks)) {
            List<String> coursePackIds = hoPacks.stream().map(it -> it.getCoursePackId()).collect(Collectors.toList());
            List<CoursePackHoPrice> prices = this.coursePackRepository.getHoPrices(coursePackIds, cityLevel);
            HashMap priceMap = Maps.newHashMap();
            prices.forEach(it -> priceMap.put(it.getCoursePackId(), it));
            for (CoursePackHo cp2 : hoPacks) {
                if (disableHoSet.contains(cp2.getCoursePackId())) continue;
                CoursePackWrapper wrapper = CoursePackWrapper.ofHo(cp2);
                if (!priceMap.containsKey(cp2.getCoursePackId())) continue;
                wrapper.setHoPrice((CoursePackHoPrice)priceMap.get(cp2.getCoursePackId()));
                list.add(wrapper);
            }
        }
        if (ArrayMapTools.isNotEmpty(schoolPacks = this.coursePackRepository.getEnablePackSchool(schoolId))) {
            schoolPacks.forEach(cp -> list.add(CoursePackWrapper.ofSchool(cp)));
        }
        return list;
    }

    public CoursePackWrapper getCoursePackWrapper(String brandId, String schoolId, String coursePackId, int cityLevel) {
        CoursePackWrapper wrapper = null;
        CoursePackHo hoPack = this.coursePackRepository.getCoursePackHo(coursePackId);
        if (hoPack != null) {
            wrapper = CoursePackWrapper.ofHo(hoPack);
            CoursePackHoPrice hoPrice = this.coursePackRepository.getHoPrice(coursePackId, cityLevel);
            wrapper.setHoPrice(hoPrice);
        } else {
            CoursePackSchool schPack = this.coursePackRepository.getCoursePackSchool(schoolId, coursePackId);
            if (schPack != null) {
                wrapper = CoursePackWrapper.ofSchool(schPack);
            }
        }
        return wrapper;
    }

    public Map<String, CoursePackWrapper> mutiGetSchoolPack(String schoolId, Collection<String> coursePackIds) {
        if (ArrayMapTools.isEmpty(coursePackIds)) {
            return null;
        }
        HashMap map = Maps.newHashMap();
        List<CoursePackHo> hoPacks = this.coursePackRepository.mutiGetCoursePackHo(coursePackIds);
        if (ArrayMapTools.isNotEmpty(hoPacks)) {
            hoPacks.forEach(it -> map.put(it.getCoursePackId(), CoursePackWrapper.ofMeta(it)));
        }
        if (coursePackIds.size() == map.size()) {
            return map;
        }
        List<CoursePackSchool> schoolPacks = this.coursePackRepository.mutiGetPackSchool(schoolId, coursePackIds);
        if (ArrayMapTools.isNotEmpty(schoolPacks)) {
            schoolPacks.forEach(it -> map.put(it.getCoursePackId(), CoursePackWrapper.ofMeta(it)));
        }
        return map;
    }

    public Map<String, CoursePackWrapper> mutiGetSchoolPackWithPackDetail(String schoolId, Collection<String> coursePackIds) {
        if (ArrayMapTools.isEmpty(coursePackIds)) {
            return null;
        }
        HashMap map = Maps.newHashMap();
        List<CoursePackHo> hoPacks = this.coursePackRepository.mutiGetCoursePackHo(coursePackIds);
        if (ArrayMapTools.isNotEmpty(hoPacks)) {
            hoPacks.forEach(it -> map.put(it.getCoursePackId(), CoursePackWrapper.ofHo(it)));
        }
        if (coursePackIds.size() == map.size()) {
            return map;
        }
        List<CoursePackSchool> schoolPacks = this.coursePackRepository.mutiGetPackSchool(schoolId, coursePackIds);
        if (ArrayMapTools.isNotEmpty(schoolPacks)) {
            schoolPacks.forEach(it -> map.put(it.getCoursePackId(), CoursePackWrapper.ofSchool(it)));
        }
        return map;
    }

    public List<String> getPackIdsByCourseId(String schoolId, int courseId) {
        School school = this.schoolService.getSchool(schoolId);
        if (school == null) {
            return null;
        }
        ArrayList packIds = Lists.newArrayList();
        packIds.addAll(this.coursePackRepository.getHoPackIdsByCourseId(school.getBrandId(), courseId));
        packIds.addAll(this.coursePackRepository.getSchoolPackIdsByCourseId(schoolId, courseId));
        return packIds;
    }

    public List<Integer> getCoursesByPackId(String brandId, String schoolId, String coursePackId) {
        List<Integer> courseIds = this.coursePackRepository.getHoCourseIds(brandId, coursePackId);
        if (ArrayMapTools.isEmpty(courseIds)) {
            courseIds = this.coursePackRepository.getSchoolCourseIds(schoolId, coursePackId);
        }
        return courseIds;
    }
}

