package com.jz.jar.franchise.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.records.LessonStudentLeaveRecord;

@Lazy
@Repository
public class LessonStudentLeaveRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.LessonStudentLeave LSL = Tables.LESSON_STUDENT_LEAVE;

	public void addLeave(String schoolId, String lessonId, String suid, String reason, String operator) {
		LessonStudentLeaveRecord leaveRecord = new LessonStudentLeaveRecord(schoolId, lessonId, suid, reason, operator);
		leaveRecord.setSchoolId(schoolId);
		leaveRecord.setLessonId(lessonId);
		leaveRecord.setSuid(suid);
		leaveRecord.setReason(reason);
		leaveRecord.setOperator(operator);
		franchiseCtx.insertInto(LSL).set(leaveRecord).execute();
	}
}
