package com.jz.jar.franchise.util;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgeCalUtil {

	private static Logger logger = LoggerFactory.getLogger(AgeCalUtil.class);

	public static int getAge(String birthDayStr) {
		Date birthDay = null;
		try {
			birthDay = DateUtils.parseDate(birthDayStr, new String[] { "yyyy-MM-dd", "yyyy-MM", "yyyy" });
		} catch (ParseException e) {
			logger.error(e.getMessage(), e);
			return 0;
		}

		Calendar cal = Calendar.getInstance();

		if (cal.before(birthDay)) {
			return 0;
		}
		int yearNow = cal.get(Calendar.YEAR);
		int monthNow = cal.get(Calendar.MONTH);
		int dayOfMonthNow = cal.get(Calendar.DAY_OF_MONTH);
		cal.setTime(birthDay);

		int yearBirth = cal.get(Calendar.YEAR);
		int monthBirth = cal.get(Calendar.MONTH);
		int dayOfMonthBirth = cal.get(Calendar.DAY_OF_MONTH);

		int age = yearNow - yearBirth;

		if (monthNow <= monthBirth) {
			if (monthNow == monthBirth) {
				if (dayOfMonthNow < dayOfMonthBirth)
					age--;
			} else {
				age--;
			}
		}
		return age;
	}

}
