package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.FUserRoleRepository;
import com.jz.jar.franchise.repository.FUserSchoolRepository;

@Lazy
@Service
public class FUserRoleService {

	@Autowired
	private FUserRoleRepository fUserRoleRepository;
	@Autowired
	private FUserSchoolRepository fUserSchoolRepository;

	public List<String> getEnableUidsByRole(String schoolId, Collection<String> roleIds) {
		List<String> uids = fUserRoleRepository.getUidsByRoles(schoolId, roleIds);
		if (ArrayMapTools.isEmpty(uids)) {
			return uids;
		}
		return fUserSchoolRepository.getEnableUids(uids, schoolId);
	}
}
