/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.alibaba.fastjson.JSON;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jar.franchise.wrapper.CaseChildWrapper;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.MarketCasePool;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Table;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class MarketCasePoolRepository
extends FranchiseBaseRepository {
    private static final com.jz.jooq.franchise.tables.MarketCasePool MCP = Tables.MARKET_CASE_POOL;

    public MarketCasePool getMarketCaseById(String caseId, String schoolId) {
        return (MarketCasePool)this.franchiseCtx.selectFrom((Table)MCP).where(new Condition[]{MarketCasePoolRepository.MCP.ID.eq((Object)caseId).and(MarketCasePoolRepository.MCP.SCHOOL_ID.eq((Object)schoolId))}).fetchAnyInto(MarketCasePool.class);
    }

    public MarketCasePool getMarketCaseByPhone(String schoolId, String phone) {
        return (MarketCasePool)this.franchiseCtx.selectFrom((Table)MCP).where(new Condition[]{MarketCasePoolRepository.MCP.SCHOOL_ID.eq((Object)schoolId).and(MarketCasePoolRepository.MCP.PHONE.eq((Object)phone))}).fetchAnyInto(MarketCasePool.class);
    }

    public MarketCasePool getMarketCaseByPuid(String schoolId, String puid) {
        return (MarketCasePool)this.franchiseCtx.selectFrom((Table)MCP).where(new Condition[]{MarketCasePoolRepository.MCP.SCHOOL_ID.eq((Object)schoolId).and(MarketCasePoolRepository.MCP.PUID.eq((Object)puid))}).fetchAnyInto(MarketCasePool.class);
    }

    public void createCase(String caseId, String uid, String schoolId, String channelId, String phone, String wechat, String qq, List<CaseChildWrapper> childs, String parentName, String relation, String address, String district, String level, long nextCommunicateTime) {
        this.franchiseCtx.insertInto((Table)MCP, (Field)MarketCasePoolRepository.MCP.ID, (Field)MarketCasePoolRepository.MCP.SCHOOL_ID, (Field)MarketCasePoolRepository.MCP.PHONE, (Field)MarketCasePoolRepository.MCP.WECHAT, (Field)MarketCasePoolRepository.MCP.QQ, (Field)MarketCasePoolRepository.MCP.PARENT_NAME, (Field)MarketCasePoolRepository.MCP.CHILD_INFO, (Field)MarketCasePoolRepository.MCP.RELATION, (Field)MarketCasePoolRepository.MCP.ADDRESS, (Field)MarketCasePoolRepository.MCP.DISTRICT, (Field)MarketCasePoolRepository.MCP.LEVEL, (Field)MarketCasePoolRepository.MCP.CHANNEL_ID, (Field)MarketCasePoolRepository.MCP.CREATED, (Field)MarketCasePoolRepository.MCP.CREATE_USER, (Field)MarketCasePoolRepository.MCP.NEXT_COMMUNICATE_TIME).values((Object)caseId, (Object)schoolId, (Object)phone, (Object)wechat, (Object)qq, (Object)parentName, (Object)(ArrayMapTools.isNotEmpty(childs) ? JSON.toJSONString(childs) : ""), (Object)relation, (Object)address, (Object)district, (Object)level, (Object)channelId, (Object)System.currentTimeMillis(), (Object)uid, (Object)nextCommunicateTime).execute();
    }
}

