/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.CoursePackCreateSetting;
import com.jz.jooq.franchise.tables.CoursePackHoDetail;
import com.jz.jooq.franchise.tables.CoursePackHoDisable;
import com.jz.jooq.franchise.tables.CoursePackSchool;
import com.jz.jooq.franchise.tables.CoursePackSchoolDetail;
import com.jz.jooq.franchise.tables.pojos.CoursePackHo;
import com.jz.jooq.franchise.tables.pojos.CoursePackHoPrice;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class CoursePackRepository
extends FranchiseBaseRepository {
    private static final com.jz.jooq.franchise.tables.CoursePackHo CPH = Tables.COURSE_PACK_HO;
    private static final CoursePackHoDetail CPHD = Tables.COURSE_PACK_HO_DETAIL;
    private static final CoursePackHoDisable CPHDIS = Tables.COURSE_PACK_HO_DISABLE;
    private static final com.jz.jooq.franchise.tables.CoursePackHoPrice CPHP = Tables.COURSE_PACK_HO_PRICE;
    private static final CoursePackSchool CPS = Tables.COURSE_PACK_SCHOOL;
    private static final CoursePackSchoolDetail CPSD = Tables.COURSE_PACK_SCHOOL_DETAIL;
    private static final CoursePackCreateSetting CPCS = Tables.COURSE_PACK_CREATE_SETTING;

    public List<CoursePackHo> getAllCoursePackHo(String brandId) {
        return this.franchiseCtx.selectFrom((Table)CPH).where(new Condition[]{CoursePackRepository.CPH.BRAND_ID.eq((Object)brandId)}).fetchInto(CoursePackHo.class);
    }

    public List<com.jz.jooq.franchise.tables.pojos.CoursePackHoDetail> getHoDetails(String brandId, Collection<String> coursePackIds) {
        return this.franchiseCtx.selectFrom((Table)CPHD).where(new Condition[]{CoursePackRepository.CPHD.COURSE_PACK_ID.in(coursePackIds)}).fetchInto(com.jz.jooq.franchise.tables.pojos.CoursePackHoDetail.class);
    }

    public List<Integer> getHoCourseIds(String brandId, String coursePackId) {
        return this.franchiseCtx.select((SelectField)CoursePackRepository.CPHD.COURSE_ID).from((TableLike)CPHD).where(new Condition[]{CoursePackRepository.CPHD.COURSE_PACK_ID.eq((Object)coursePackId)}).fetchInto(Integer.class);
    }

    public List<String> getHoDisable(String schoolId) {
        return this.franchiseCtx.select((SelectField)CoursePackRepository.CPHDIS.COURSE_PACK_ID).from((TableLike)CPHDIS).where(new Condition[]{CoursePackRepository.CPHDIS.SCHOOL_ID.eq((Object)schoolId)}).fetchInto(String.class);
    }

    public List<CoursePackHoPrice> getHoPrices(Collection<String> coursePackIds, int cityLevel) {
        return this.franchiseCtx.selectFrom((Table)CPHP).where(new Condition[]{CoursePackRepository.CPHP.COURSE_PACK_ID.in(coursePackIds).and(CoursePackRepository.CPHP.CITY_LEVEL.eq((Object)cityLevel))}).fetchInto(CoursePackHoPrice.class);
    }

    public CoursePackHoPrice getHoPrice(String coursePackId, int cityLevel) {
        return (CoursePackHoPrice)this.franchiseCtx.selectFrom((Table)CPHP).where(new Condition[]{CoursePackRepository.CPHP.COURSE_PACK_ID.eq((Object)coursePackId).and(CoursePackRepository.CPHP.CITY_LEVEL.eq((Object)cityLevel))}).fetchAnyInto(CoursePackHoPrice.class);
    }

    public List<com.jz.jooq.franchise.tables.pojos.CoursePackSchool> getPackSchool(String schoolId) {
        return this.franchiseCtx.selectFrom((Table)CPS).where(new Condition[]{CoursePackRepository.CPS.SCHOOL_ID.eq((Object)schoolId)}).fetchInto(com.jz.jooq.franchise.tables.pojos.CoursePackSchool.class);
    }

    public List<com.jz.jooq.franchise.tables.pojos.CoursePackSchool> getEnablePackSchool(String schoolId) {
        return this.franchiseCtx.selectFrom((Table)CPS).where(new Condition[]{CoursePackRepository.CPS.SCHOOL_ID.eq((Object)schoolId).and(CoursePackRepository.CPS.ENABLE.eq((Object)1))}).fetchInto(com.jz.jooq.franchise.tables.pojos.CoursePackSchool.class);
    }

    public List<com.jz.jooq.franchise.tables.pojos.CoursePackSchoolDetail> getSchoolDetail(String schoolId) {
        return this.franchiseCtx.selectFrom((Table)CPSD).where(new Condition[]{CoursePackRepository.CPSD.SCHOOL_ID.eq((Object)schoolId)}).fetchInto(com.jz.jooq.franchise.tables.pojos.CoursePackSchoolDetail.class);
    }

    public List<Integer> getSchoolCourseIds(String schoolId, String coursePackId) {
        return this.franchiseCtx.select((SelectField)CoursePackRepository.CPSD.COURSE_ID).from((TableLike)CPSD).where(new Condition[]{CoursePackRepository.CPSD.SCHOOL_ID.eq((Object)schoolId).and(CoursePackRepository.CPSD.COURSE_PACK_ID.eq((Object)coursePackId))}).fetchInto(Integer.class);
    }

    public List<CoursePackHo> mutiGetCoursePackHo(Collection<String> coursePackIds) {
        return this.franchiseCtx.selectFrom((Table)CPH).where(new Condition[]{CoursePackRepository.CPH.COURSE_PACK_ID.in(coursePackIds)}).fetchInto(CoursePackHo.class);
    }

    public List<com.jz.jooq.franchise.tables.pojos.CoursePackSchool> mutiGetPackSchool(String schoolId, Collection<String> coursePackIds) {
        return this.franchiseCtx.selectFrom((Table)CPS).where(new Condition[]{CoursePackRepository.CPS.SCHOOL_ID.eq((Object)schoolId).and(CoursePackRepository.CPS.COURSE_PACK_ID.in(coursePackIds))}).fetchInto(com.jz.jooq.franchise.tables.pojos.CoursePackSchool.class);
    }

    public CoursePackHo getCoursePackHo(String coursePackId) {
        return (CoursePackHo)this.franchiseCtx.selectFrom((Table)CPH).where(new Condition[]{CoursePackRepository.CPH.COURSE_PACK_ID.eq((Object)coursePackId)}).fetchAnyInto(CoursePackHo.class);
    }

    public com.jz.jooq.franchise.tables.pojos.CoursePackSchool getCoursePackSchool(String schoolId, String coursePackId) {
        return (com.jz.jooq.franchise.tables.pojos.CoursePackSchool)this.franchiseCtx.selectFrom((Table)CPS).where(new Condition[]{CoursePackRepository.CPS.SCHOOL_ID.eq((Object)schoolId).and(CoursePackRepository.CPS.COURSE_PACK_ID.eq((Object)coursePackId))}).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.CoursePackSchool.class);
    }

    public com.jz.jooq.franchise.tables.pojos.CoursePackCreateSetting getCreateSetting(String brandId, int cityLevel) {
        return (com.jz.jooq.franchise.tables.pojos.CoursePackCreateSetting)this.franchiseCtx.selectFrom((Table)CPCS).where(new Condition[]{CoursePackRepository.CPCS.BRAND_ID.eq((Object)brandId).and(CoursePackRepository.CPCS.CITY_LEVEL.eq((Object)cityLevel))}).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.CoursePackCreateSetting.class);
    }

    public List<String> getHoPackIdsByCourseId(String brandId, int courseId) {
        return this.franchiseCtx.select((SelectField)CoursePackRepository.CPHD.COURSE_PACK_ID).from((TableLike)CPHD).where(new Condition[]{CoursePackRepository.CPHD.BRAND_ID.eq((Object)brandId).and(CoursePackRepository.CPHD.COURSE_ID.eq((Object)courseId))}).fetchInto(String.class);
    }

    public List<String> getSchoolPackIdsByCourseId(String schoolId, int courseId) {
        return this.franchiseCtx.select((SelectField)CoursePackRepository.CPSD.COURSE_PACK_ID).from((TableLike)CPSD).where(new Condition[]{CoursePackRepository.CPSD.SCHOOL_ID.eq((Object)schoolId).and(CoursePackRepository.CPSD.COURSE_ID.eq((Object)courseId))}).fetchInto(String.class);
    }
}

