package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;

@Lazy
@Repository
public class StudentSchoolRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.StudentSchool SS = Tables.STUDENT_SCHOOL;

	public boolean isContainsSchool(String suid) {
		return franchiseCtx.fetchExists(SS, SS.SUID.eq(suid).and(SS.HAVE_CONTRACT.eq(1)));
	}

	public List<String> getContainsSchool(Collection<String> suidArray) {
		return franchiseCtx.select(SS.SUID).from(SS).where(SS.SUID.in(suidArray).and(SS.HAVE_CONTRACT.eq(1)))
				.fetchInto(String.class);
	}

}
