package com.jz.jar.franchise.wrapper;

import java.math.BigDecimal;

import org.apache.commons.lang3.StringUtils;

import com.jz.jar.franchise.common.FranchiseGobal;
import com.jz.jooq.franchise.tables.pojos.School;

public class SchoolWrapper {

	private String schoolId;
	private String schoolName;

	private String brandId;
	private Integer cityLevel;
	private Double lat;
	private Double lng;
	private Integer code;
	private Integer type;
	private Integer qualityType;
	private String phone;
	private RegionWrapper region; //
	private String prov;
	private String company;
	private String centerName;
	private String centerAddress;
	private String stamp;
	private String merchantCode;
	private Integer status;
	private Long created;
	private Long prepareEndTime;
	private Long openTime;
	private Long joinTime;
	private Long contractEndTime;
	private Double qyRate;
	private UserSimpleWrapper investor; //
	private Integer staffNum;
	
	private Integer unReadNum;

	public static SchoolWrapper ofSimple(School school) {
		return new SchoolWrapper().setSchoolId(school.getId()).setSchoolName(school.getName())
				.setCode(school.getCode());
	}

	public static SchoolWrapper ofContract(School school) {
		return new SchoolWrapper().setSchoolId(school.getId()).setSchoolName(school.getName())
				.setCompany(school.getCompany()).setCenterName(school.getCenterName())
				.setCenterAddress(school.getCenterAddress()).setStamp(school.getStamp());
	}

	public static SchoolWrapper ofAllInfo(School school) {
		return new SchoolWrapper().setSchoolId(school.getId()).setSchoolName(school.getName())
				.setBrandId(school.getBrandId()).setCityLevel(school.getCityLevel()).setLat(school.getLat())
				.setLng(school.getLng()).setCode(school.getCode()).setType(school.getType())
				.setQualityType(school.getQualityType()).setPhone(school.getPhone()).setProv(school.getProv())
				.setCompany(school.getCompany()).setCenterName(school.getCenterName())
				.setCenterAddress(school.getCenterAddress()).setStamp(school.getStamp())
				.setMerchantCode(school.getMerchantCode()).setStatus(school.getStatus())
				.setCreated(school.getCreated()).setPrepareEndTime(school.getPrepareEndTime())
				.setOpenTime(school.getOpenTime()).setJoinTime(school.getJoinTime())
				.setContractEndTime(school.getContractEndTime()).setQyRate(school.getQyRate());
	}

	public String getSchoolId() {
		return schoolId;
	}

	public SchoolWrapper setSchoolId(String schoolId) {
		this.schoolId = schoolId;
		return this;
	}

	public String getSchoolName() {
		return schoolName;
	}

	public SchoolWrapper setSchoolName(String schoolName) {
		this.schoolName = schoolName;
		return this;
	}

	public String getCompany() {
		return company;
	}

	public SchoolWrapper setCompany(String company) {
		this.company = company;
		return this;
	}

	public String getCenterName() {
		return centerName;
	}

	public SchoolWrapper setCenterName(String centerName) {
		this.centerName = centerName;
		return this;
	}

	public String getCenterAddress() {
		return centerAddress;
	}

	public SchoolWrapper setCenterAddress(String centerAddress) {
		this.centerAddress = centerAddress;
		return this;
	}

	public String getStamp() {
		return stamp;
	}

	public SchoolWrapper setStamp(String stamp) {
		if (StringUtils.isNotEmpty(stamp)) {
			this.stamp = FranchiseGobal.picAddressPrefix + stamp;
		} else {
			this.stamp = stamp;
		}
		return this;
	}

	public String getBrandId() {
		return brandId;
	}

	public SchoolWrapper setBrandId(String brandId) {
		this.brandId = brandId;
		return this;
	}

	public Integer getCityLevel() {
		return cityLevel;
	}

	public SchoolWrapper setCityLevel(Integer cityLevel) {
		this.cityLevel = cityLevel;
		return this;
	}

	public Double getLat() {
		return lat;
	}

	public SchoolWrapper setLat(Double lat) {
		this.lat = lat;
		return this;
	}

	public Double getLng() {
		return lng;
	}

	public SchoolWrapper setLng(Double lng) {
		this.lng = lng != null ? lng.doubleValue() : null;
		return this;
	}

	public Integer getCode() {
		return code;
	}

	public SchoolWrapper setCode(Integer code) {
		this.code = code;
		return this;
	}

	public Integer getType() {
		return type;
	}

	public SchoolWrapper setType(Integer type) {
		this.type = type;
		return this;
	}

	public Integer getQualityType() {
		return qualityType;
	}

	public SchoolWrapper setQualityType(Integer qualityType) {
		this.qualityType = qualityType;
		return this;
	}

	public String getPhone() {
		return phone;
	}

	public SchoolWrapper setPhone(String phone) {
		this.phone = phone;
		return this;
	}

	public RegionWrapper getRegion() {
		return region;
	}

	public SchoolWrapper setRegion(RegionWrapper region) {
		this.region = region;
		return this;
	}

	public String getProv() {
		return prov;
	}

	public SchoolWrapper setProv(String prov) {
		this.prov = prov;
		return this;
	}

	public String getMerchantCode() {
		return merchantCode;
	}

	public SchoolWrapper setMerchantCode(String merchantCode) {
		this.merchantCode = merchantCode;
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public SchoolWrapper setStatus(Integer status) {
		this.status = status;
		return this;
	}

	public Long getCreated() {
		return created;
	}

	public SchoolWrapper setCreated(Long created) {
		this.created = created;
		return this;
	}

	public Long getContractEndTime() {
		return contractEndTime;
	}

	public SchoolWrapper setContractEndTime(Long contractEndTime) {
		this.contractEndTime = contractEndTime;
		return this;
	}

	public Long getPrepareEndTime() {
		return prepareEndTime;
	}

	public SchoolWrapper setPrepareEndTime(Long prepareEndTime) {
		this.prepareEndTime = prepareEndTime;
		return this;
	}

	public Long getOpenTime() {
		return openTime;
	}

	public SchoolWrapper setOpenTime(Long openTime) {
		this.openTime = openTime;
		return this;
	}

	public Long getJoinTime() {
		return joinTime;
	}

	public SchoolWrapper setJoinTime(Long joinTime) {
		this.joinTime = joinTime;
		return this;
	}

	public Double getQyRate() {
		return qyRate;
	}

	public SchoolWrapper setQyRate(BigDecimal qyRate) {
		this.qyRate = qyRate != null ? qyRate.doubleValue() : null;
		return this;
	}

	public UserSimpleWrapper getInvestor() {
		return investor;
	}

	public SchoolWrapper setInvestor(UserSimpleWrapper investor) {
		this.investor = investor;
		return this;
	}

	public Integer getStaffNum() {
		return staffNum;
	}

	public SchoolWrapper setStaffNum(Integer staffNum) {
		this.staffNum = staffNum;
		return this;
	}

	public Integer getUnReadNum() {
		return unReadNum;
	}

	public SchoolWrapper setUnReadNum(Integer unReadNum) {
		this.unReadNum = unReadNum;
		return this;
	}

}
