package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.StudentInfoRepository;
import com.jz.jooq.franchise.tables.pojos.StudentInfo;

/**
 * @Title StudentInfoService
 * @Package com.jz.jar.franchise.service
 * @author tangjunfeng
 * @date 2018年8月3日 下午3:24:23
 * @version V1.0
 */
@Lazy
@Service
public class StudentInfoService {

	@Autowired
	private StudentInfoRepository studentInfoRepository;

	public String getStudentBirthday(String suid) {
		return studentInfoRepository.getStudentBirthday(suid);
	}

	public void refreshStudent(String puid, String suid, String cnName, String enName, String sex, String birthday, String avatar) {
		studentInfoRepository.refreshStudent(puid, suid, cnName, enName, sex, birthday, avatar);
	}

	public List<StudentInfo> getStudents(String puid) {
		return studentInfoRepository.getStudents(puid);
	}

	public StudentInfo getStudent(String suid) {
		return studentInfoRepository.getStudent(suid);
	}
	
	public List<StudentInfo> getSimpleStudentInfo(Collection<String> puids) {
		return studentInfoRepository.getSimpleStudentInfo(puids);
	}
}
