package com.jz.jar.franchise.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.LessonStudent;

@Lazy
@Repository
public class LessonStudentRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.LessonStudent LS = Tables.LESSON_STUDENT;

	public List<LessonStudent> findSimpleLessonStudentInfo(String suid) {
		return franchiseCtx.select(LS.SCHOOL_ID, LS.LESSON_ID, LS.CONTRACT_ID, LS.STATUS).from(LS)
				.where(LS.SUID.eq(suid)).fetchInto(LessonStudent.class);
	}

	public LessonStudent getLessonStudent(String schoolId, String lessonId, String suid) {
		List<LessonStudent> fetchInto = franchiseCtx.selectFrom(LS)
				.where(LS.SCHOOL_ID.eq(schoolId).and(LS.LESSON_ID.eq(lessonId)).and(LS.SUID.eq(suid)))
				.fetchInto(LessonStudent.class);
		return ArrayMapTools.isNotEmpty(fetchInto) ? fetchInto.get(0) : null;
	}

	public void updateStatus(String schoolId, String lessonId, String suid, int status) {
		franchiseCtx.update(LS).set(LS.STATUS, status)
				.where(LS.SCHOOL_ID.eq(schoolId).and(LS.LESSON_ID.eq(lessonId)).and(LS.SUID.eq(suid))).execute();
	}

	public List<LessonStudent> findFinishedLessonInfo(String suid) {
		return franchiseCtx.select(LS.SCHOOL_ID, LS.LESSON_ID, LS.STATUS).from(LS)
				.where(LS.SUID.eq(suid).and(LS.TYPE.eq(1)).and(LS.STATUS.in(1, 2, 4))).fetchInto(LessonStudent.class);
	}
}
