package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.ParentInfoRepository;
import com.jz.jar.franchise.wrapper.ParentWrapper;
import com.jz.jooq.franchise.tables.pojos.ParentInfo;

@Lazy
@Service
public class ParentInfoService {

	@Autowired
	private ParentInfoRepository parentInfoRepository;

	public void savePatentInfo(String puid, String phone, int appLogin) {
		parentInfoRepository.savePatentInfo(puid, phone, appLogin);
	}

	public ParentInfo getParentInfoForPhone(String phone) {
		return parentInfoRepository.getParentInfoForPhone(phone);
	}

	public void updateAppLogin(String phone) {
		parentInfoRepository.updateAppLogin(phone);
	}

	public void updateAddressForUid(String puid, String address) {
		parentInfoRepository.updateAddressForUid(puid, address);
	}

	public ParentInfo getParentInfoForId(String uid) {
		return parentInfoRepository.getParentInfoForId(uid);
	}

	public ParentWrapper getParentWrapper(String puid) {
		ParentInfo pi = this.getParentInfoForId(puid);
		return pi != null ? ParentWrapper.of(pi) : null;
	}
	
	public List<ParentInfo> getSimpleParentInfo(Collection<String> puids) {
		return parentInfoRepository.getSimpleParentInfo(puids);
	}
	
	public int countExistUid(String... uids) {
		return parentInfoRepository.countExistUid(uids);
	}
}
