package com.jz.jar.franchise.repository;

import java.util.List;

import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.Recruit;

@Lazy
@Repository
public class RecruitRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.Recruit RT = Tables.RECRUIT;
	private static final com.jz.jooq.franchise.tables.RecruitSchool RS = Tables.RECRUIT_SCHOOL;

	private Condition getCondition(String school) {
		return RS.SCHOOL_ID.eq(school).and(RS.STATUS.eq(1));
	}

	public int cntRecruits(String school) {
		return franchiseCtx.fetchCount(RS, getCondition(school));
	}

	public List<String> getRecruitIds(String school, int start, int size) {
		// 0未发布 1已发布 2取消发布
		return franchiseCtx.select(RS.RID).from(RS).where(getCondition(school)).orderBy(RS.CREATE_TIME.desc())
				.limit(start, size).fetchInto(String.class);
	}

	public List<Recruit> getListRecruitInfo(List<String> rids) {
		return franchiseCtx.select(RT.RID, RT.POSITION, RT.SALARY_RANGE).from(RT).where(RT.RID.in(rids))
				.orderBy(RT.CREATE_TIME.desc()).fetchInto(Recruit.class);
	}

	public Recruit getRecruitInfo(String rid) {
		return ArrayMapTools.getFirst(franchiseCtx.selectFrom(RT).where(RT.RID.eq(rid)).fetchInto(Recruit.class));
	}

}
