package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.StudentSchoolContractRepository;
import com.jz.jooq.franchise.tables.pojos.StudentSchoolContract;
import com.jz.jooq.franchise.tables.pojos.StudentSchoolExtra;

@Lazy
@Service
public class StudentSchoolContractService {

	@Autowired
	private StudentSchoolContractRepository studentSchoolContractRepository;

	public Pair<Integer, Integer> getLessionCount(String suid, Collection<String> schoolIds) {
		return studentSchoolContractRepository.getLessionCount(suid, schoolIds);
	}

	public Map<String, Pair<Integer, Integer>> getLessionCount(Collection<String> suids, Collection<String> schoolIds) {
		return studentSchoolContractRepository.getLessionCount(suids, schoolIds);
	}

	/** 获取当前合同已经请假的天数 */
	public List<StudentSchoolContract> getSimpleStudentSchoolContracts(String suid,
			Map<String, Collection<String>> school2ContractId) {
		return studentSchoolContractRepository.getSimpleStudentSchoolContracts(suid, school2ContractId);
	}

	public StudentSchoolContract getStudentSchoolContract(String suid, String school, String contractId) {
		return studentSchoolContractRepository.getStudentSchoolContract(suid, school, contractId);
	}

	public void addLeaveNum(String suid, String school, String contractId, int addCnt) {
		studentSchoolContractRepository.addLeaveNum(suid, school, contractId, addCnt);
	}

	public List<StudentSchoolContract> getSSCByContractId(String schoolId, String contractId) {
		return studentSchoolContractRepository.getSSCByContractId(schoolId, contractId);
	}

	public List<String> getIsContinueContract(List<String> contractIds) {
		return studentSchoolContractRepository.getIsContinueContract(contractIds);
	}

	public boolean dealRollbackOfficalLesson(String suid, String schoolId, String contractId, int rollbackNum) {
		return studentSchoolContractRepository.dealRollbackOfficalLesson(suid, schoolId, contractId, rollbackNum);
	}

	public boolean dealRollbackExtraLesson(String suid, String schoolId, int extraId, int rollbackNum) {
		return studentSchoolContractRepository.dealRollbackExtraLesson(suid, schoolId, extraId, rollbackNum);
	}

	public List<StudentSchoolExtra> getContractExtrasInSchool(String schoolId, String contractId) {
		return studentSchoolContractRepository.getContractExtrasInSchool(schoolId, contractId);
	}

	/** 获取学员的课时数 */
	public Map<String, List<StudentSchoolContract>> getStudentLessonCount(Collection<String> suids,
			Collection<String> schoolIds) {
		return studentSchoolContractRepository.getStudentLessonCount(suids, schoolIds);
	}

	/** 获取学员的赠课时数 */
	public Map<String, List<StudentSchoolExtra>> getStudentExtraLessonCount(Map<String, List<String>> suid2SchoolIds) {
		return studentSchoolContractRepository.getStudentExtraLessonCount(suid2SchoolIds);
	}

	public StudentSchoolExtra getExtra(int extraId, String suid) {
		return studentSchoolContractRepository.getExtra(extraId, suid);
	}

	public Map<Integer, String> getExtraId2ContractMap(String suid) {
		return studentSchoolContractRepository.getExtraId2ContractMap(suid);
	}

	public boolean isExistValidContract(String suid) {
		return studentSchoolContractRepository.isExistValidContract(suid);
	}

	public boolean isExistContract(String suid) {
		return studentSchoolContractRepository.isExistContract(suid);
	}

	public String getLastContractSchoolId(String suid, Collection<String> schoolIds) {
		return studentSchoolContractRepository.getLastContractSchoolId(suid, schoolIds);
	}

	public List<String> getContractIdsBySuid(String suid) {
		return studentSchoolContractRepository.getContractIdsBySuid(suid);
	}
}
