package com.jz.jar.franchise.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.ActivityHoRepository;
import com.jz.jooq.franchise.tables.pojos.ActivityHo;
import com.jz.jooq.franchise.tables.pojos.ActivityTemplateArtCommon;

@Lazy
@Service
public class ActivityHoService {

	@Autowired
	private ActivityHoRepository activityHoRepository;

	public int countOnlineActivities(String brandId) {
		return activityHoRepository.countOnlineActivities(brandId);
	}

	public List<ActivityHo> findAllOnlineActivities(String brandId, int start, int size) {
		return activityHoRepository.findAllOnlineActivities(brandId, start, size);
	}

	public List<ActivityTemplateArtCommon> getPublishExcludeNoStartTemplate(String brandId, int size) {
		return activityHoRepository.getPublishExcludeNoStartTemplate(brandId, size);
	}

	public boolean existCurrentPublishAllowWorksTemplate(String brandId) {
		return activityHoRepository.existCurrentPublishAllowWorksTemplate(brandId);
	}
}
