package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.StudentStudyOnline;

@Lazy
@Repository
public class StudentStudyOnlineRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.StudentStudyOnline SSO = Tables.STUDENT_STUDY_ONLINE;

	public int getPlayLength(String suid, String wid) {
		Integer rs = franchiseCtx.select(SSO.PLAY_LENGTH).from(SSO).where(SSO.SUID.eq(suid).and(SSO.WID.eq(wid)))
				.fetchAnyInto(Integer.class);
		return rs != null ? rs : 0;
	}

	public StudentStudyOnline getStudentOnline(String suid, String wid) {
		return franchiseCtx.selectFrom(SSO).where(SSO.SUID.eq(suid).and(SSO.WID.eq(wid)))
				.fetchAnyInto(StudentStudyOnline.class);
	}

	public List<StudentStudyOnline> mutiGetPlayLength(String suid, Collection<String> wids) {
		return franchiseCtx.selectFrom(SSO).where(SSO.SUID.eq(suid).and(SSO.WID.in(wids)))
				.fetchInto(StudentStudyOnline.class);
	}

	public void insUpdatePlayLength(String suid, String wid, int playLength, int maxPlayLength) {
		franchiseCtx.insertInto(SSO, SSO.SUID, SSO.WID, SSO.PLAY_LENGTH, SSO.MAX_PLAY_LENGTH)
				.values(suid, wid, playLength, maxPlayLength).onDuplicateKeyUpdate().set(SSO.PLAY_LENGTH, playLength)
				.set(SSO.MAX_PLAY_LENGTH, maxPlayLength).execute();
	}

}
