package com.jz.jar.franchise.service;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.CouponInfoRepository;
import com.jz.jooq.franchise.tables.pojos.CouponInfo;

@Lazy
@Service
public class CouponInfoService {

	@Autowired
	private CouponInfoRepository couponInfoRepository;

	public List<CouponInfo> getCouponsByPuid(String puid, Integer filterUsageType) {
		return couponInfoRepository.getCouponsByPuid(puid, filterUsageType);
	}

	public CouponInfo getCouponByCode(String couponCode) {
		return couponInfoRepository.getCouponByCode(couponCode);
	}

	public void updateTransfer(String couponCode, String sourcePuid, String targetPuid) {
		couponInfoRepository.updateTransfer(couponCode, sourcePuid, targetPuid);
	}

	public Map<String, String> listSubjectId2NameMap() {
		return couponInfoRepository.listSubjectId2NameMap();
	}
}
