package com.jz.jar.franchise.service;

import java.util.List;

import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.jz.jar.franchise.repository.AppraiseSettingRepository;
import com.jz.jooq.franchise.tables.pojos.AppraiseSetting;
import com.jz.jooq.franchise.tables.pojos.LessonStudentFeedBack;

@Lazy
@Service
public class AppraiseSettingService {

	@Autowired
	private AppraiseSettingRepository appraiseRepository;

	public List<AppraiseSetting> findAppraiseInfo(String level, List<Pair<Integer, String>> starCnt2Name) {
		return appraiseRepository.findAppraiseInfo(level, starCnt2Name);
	}

	public List<Pair<Integer, String>> getStarCntAndName(LessonStudentFeedBack fb) {
		List<Pair<Integer, String>> starCnt2Name = Lists.newArrayList();
		if (null != fb.getConcentration() && fb.getConcentration() > 0) {
			starCnt2Name.add(Pair.of(getStarCnt(fb.getConcentration()), "感知理解"));
		}
		if (null != fb.getAttitude() && fb.getAttitude() > 0) {
			starCnt2Name.add(Pair.of(getStarCnt(fb.getAttitude()), "多向思维"));
		}
		if (null != fb.getFeedback() && fb.getFeedback() > 0) {
			starCnt2Name.add(Pair.of(getStarCnt(fb.getFeedback()), "成长转变"));
		}
		if (null != fb.getPerformance() && fb.getPerformance() > 0) {
			starCnt2Name.add(Pair.of(getStarCnt(fb.getPerformance()), "创新决策"));
		}
		if (null != fb.getMultiAi() && fb.getMultiAi() > 0) {
			starCnt2Name.add(Pair.of(getStarCnt(fb.getMultiAi()), "多元智能"));
		}
		if (null != fb.getArtHorizons() && fb.getArtHorizons() > 0) {
			starCnt2Name.add(Pair.of(getStarCnt(fb.getArtHorizons()), "艺术视野"));
		}
		return starCnt2Name;
	}

	private int getStarCnt(int startCnt) {
		return startCnt < 4 ? startCnt : 4;
	}

	public List<AppraiseSetting> listAppraiseByLevel(String level) {
		return appraiseRepository.listAppraiseByLevel(level);
	}
}
