package com.jz.jar.franchise.service;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.common.utils.security.EncryptionTools;
import com.jz.jar.franchise.cache.FranchiseTokenKeyCache;
import com.jz.jar.franchise.repository.FUserInfoRepository;

@Lazy
@Service
public class FranchiseTokenCalService {
	private Logger logger = LoggerFactory.getLogger(FranchiseTokenCalService.class);

	@Autowired
	private FranchiseTokenKeyCache tokenKeyCache;
	@Autowired
	private FUserInfoRepository fUserInfoRepository;

	public boolean checkTokenIlle(String uid, String token) {
		if (StringUtils.isEmpty(uid)) {
			return false;
		}
		if (StringUtils.isEmpty(token)) {
			return false;
		}
		String[] parts = StringUtils.split(token, "_");
		if (parts.length != 2) {
			return false;
		}
		long endTime = Long.parseLong(parts[1]);
		String oldToken = parts[0];
		if (endTime < System.currentTimeMillis()) {
			return false;
		}
		String calToken = calToken(uid, endTime);
		if (StringUtils.equals(calToken, oldToken)) {
			return true;
		} else {
			return false;
		}
	}

	public String getNewToken(String uid) {
		int hours = 72; // token有效期72小时写死
		long endTime = System.currentTimeMillis() + hours * 3600 * 1000l;
		return calToken(uid, endTime) + "_" + endTime;
	}

	private String calToken(String uid, long endTime) {
		String str = getKey(uid) + "jz" + endTime;
		return EncryptionTools.MD5(str, false);
	}

	private String getKey(String uid) {
		String pwdPart = tokenKeyCache.getPwdPart(uid);
		if (StringUtils.isNotEmpty(pwdPart)) {
			return pwdPart;
		}
		String pwd = fUserInfoRepository.getUserPwd(uid);
		if (pwd == null) {
			logger.warn("dirty uid:" + uid);
			return StringUtils.substring(uid, uid.length() / 2, uid.length());
		}
		pwdPart = StringUtils.substring(pwd, pwd.length() - 6, pwd.length());
		tokenKeyCache.setPwdPart(uid, pwdPart);
		return pwdPart;
	}

	public void cleanCache(String uid) {
		tokenKeyCache.delPwdPart(uid);
	}

}
