package com.jz.jar.franchise.wrapper;

import com.jz.jooq.franchise.tables.pojos.CourseTomatoPlanOs;

/**
 * @author 连杰
 */
public class OnlineLessonWrapper {
	private OnlineLessonWrapper() {
	}

	private String wid;
	private String lessonName; // 课程名称教案名称
	private String courseName; // 课阶名称
	private Long startTime;
	private Long endTime;
	private String content; // 课程描述
	private String homework; // 作业
	private Integer type; // 0不需要提交作业 1需要提交作业

	public static OnlineLessonWrapper of(CourseTomatoPlanOs s, int type) {
		return new OnlineLessonWrapper().setWid(s.getWid()).setStartTime(s.getStartTime()).setEndTime(s.getEndTime())
				.setContent(s.getContent()).setHomework(s.getHomework()).setType(type);
	}

	public String getWid() {
		return wid;
	}

	public OnlineLessonWrapper setWid(String wid) {
		this.wid = wid;
		return this;
	}

	public String getLessonName() {
		return lessonName;
	}

	public OnlineLessonWrapper setLessonName(String lessonName) {
		this.lessonName = lessonName;
		return this;
	}

	public String getCourseName() {
		return courseName;
	}

	public OnlineLessonWrapper setCourseName(String courseName) {
		this.courseName = courseName;
		return this;
	}

	public Long getStartTime() {
		return startTime;
	}

	public OnlineLessonWrapper setStartTime(Long startTime) {
		this.startTime = startTime;
		return this;
	}

	public Long getEndTime() {
		return endTime;
	}

	public OnlineLessonWrapper setEndTime(Long endTime) {
		this.endTime = endTime;
		return this;
	}

	public String getContent() {
		return content;
	}

	public OnlineLessonWrapper setContent(String content) {
		this.content = content;
		return this;
	}

	public String getHomework() {
		return homework;
	}

	public OnlineLessonWrapper setHomework(String homework) {
		this.homework = homework;
		return this;
	}

	public Integer getType() {
		return type;
	}

	public OnlineLessonWrapper setType(Integer type) {
		this.type = type;
		return this;
	}

}
