package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.CourseTomato;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class CourseTomatoRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.CourseTomato CT = Tables.COURSE_TOMATO;

	public List<CourseTomato> mutiGetCourses(String brandId, Collection<Integer> courseIds) {
		return franchiseCtx.selectFrom(CT).where(CT.BRAND_ID.eq(brandId).and(CT.COURSE_ID.in(courseIds)))
				.fetchInto(CourseTomato.class);
	}

	public String getCourseLevel(String brandId, int courseId) {
		return franchiseCtx.select(CT.LEVEL).from(CT).where(CT.BRAND_ID.eq(brandId).and(CT.COURSE_ID.eq(courseId)))
				.fetchAnyInto(String.class);
	}

	public List<String> listOfficialCoursesSchool(String brandId, List<Integer> specCourseIds, int ver) {
		if (ArrayMapTools.isNotEmpty(specCourseIds)) {
			return franchiseCtx.select(CT.LEVEL).from(CT)
					.where(CT.BRAND_ID.eq(brandId).and(CT.VER.eq(ver))
							.and(CT.STATUS.eq(1).or(CT.COURSE_ID.in(specCourseIds))).and(CT.LEVEL.isNotNull()))
					.groupBy(CT.LEVEL).orderBy(CT.LEVEL.asc()).fetchInto(String.class);
		} else {
			return franchiseCtx.select(CT.LEVEL).from(CT)
					.where(CT.BRAND_ID.eq(brandId).and(CT.VER.eq(ver)).and(CT.STATUS.eq(1)).and(CT.LEVEL.isNotNull()))
					.groupBy(CT.LEVEL).orderBy(CT.LEVEL.asc()).fetchInto(String.class);
		}
	}

}
