/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.CourseRepository;
import com.jz.jar.franchise.repository.CourseTomatoRepository;
import com.jz.jar.franchise.service.CourseFreeSettingService;
import com.jz.jar.franchise.service.CourseHoLessonService;
import com.jz.jar.franchise.wrapper.CourseWrapper;
import com.jz.jooq.franchise.tables.pojos.CourseHoLesson;
import com.jz.jooq.franchise.tables.pojos.CourseTomato;
import com.jz.jooq.franchise.tables.pojos.Lesson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class CourseService {
    @Autowired
    private CourseRepository courseRepository;
    @Autowired
    private CourseTomatoRepository courseTomatoRepository;
    @Autowired
    private CourseFreeSettingService courseFreeSettingService;
    @Autowired
    private CourseHoLessonService courseHoLessonService;

    public Map<Integer, CourseWrapper> mutiGetCourseInfoMap(String brandId, Collection<Integer> courseIds) {
        List<CourseTomato> hos;
        HashMap map = Maps.newHashMap();
        ArrayList officalCourseIds = Lists.newArrayList();
        for (Integer courseId : courseIds) {
            if (courseId < 0) {
                CourseWrapper cw = this.courseFreeSettingService.getFreeCourseWrapper(brandId, courseId);
                if (cw == null) continue;
                map.put(courseId, cw);
                continue;
            }
            officalCourseIds.add(courseId);
        }
        if (StringUtils.equals((CharSequence)brandId, (CharSequence)"tomato")) {
            hos = this.courseTomatoRepository.mutiGetCourses(brandId, officalCourseIds);
            if (ArrayMapTools.isNotEmpty(hos)) {
                hos.forEach(it -> map.put(it.getCourseId(), CourseWrapper.ofHo(it)));
            }
        } else {
            hos = this.courseRepository.mutiGetHoCourse(brandId, officalCourseIds);
            if (ArrayMapTools.isNotEmpty(hos)) {
                hos.forEach(it -> map.put(it.getCourseId(), CourseWrapper.ofHo(it)));
            }
        }
        return map;
    }

    public Map<String, String> mutiCalSchoolSimplePlans(String brandId, List<Lesson> lessonArray) {
        if (ArrayMapTools.isEmpty(lessonArray)) {
            return Maps.newHashMap();
        }
        HashMap course2LessonTimes = Maps.newHashMap();
        for (Lesson l : lessonArray) {
            if (course2LessonTimes.containsKey(l.getCourseId())) {
                ((Collection)course2LessonTimes.get(l.getCourseId())).add(l.getLessonTime());
                continue;
            }
            course2LessonTimes.put(l.getCourseId(), Lists.newArrayList((Object[])new Integer[]{l.getLessonTime()}));
        }
        List<CourseHoLesson> titles = this.courseHoLessonService.findSimpleHoLession(brandId, course2LessonTimes);
        HashMap courseId2LessonTime2Title = Maps.newHashMap();
        for (CourseHoLesson t : titles) {
            if (!courseId2LessonTime2Title.containsKey(t.getCourseId())) {
                courseId2LessonTime2Title.put(t.getCourseId(), Maps.newHashMap());
            }
            ((Map)courseId2LessonTime2Title.get(t.getCourseId())).put(t.getLessonTime(), t.getLessonTitle());
        }
        HashMap lessonId2TitleMap = Maps.newHashMap();
        for (Lesson l : lessonArray) {
            Map lessonTime2title = (Map)courseId2LessonTime2Title.get(l.getCourseId());
            if (lessonTime2title == null || !lessonTime2title.containsKey(l.getLessonTime())) continue;
            lessonId2TitleMap.put(l.getLessonId(), lessonTime2title.get(l.getLessonTime()));
        }
        return lessonId2TitleMap;
    }
}

