package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.ContractTerms;
import com.jz.jooq.franchise.tables.pojos.ContractTermsDetail;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class ContractTermsRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.ContractTerms CT = Tables.CONTRACT_TERMS;
	private static final com.jz.jooq.franchise.tables.ContractTermsDetail CTD = Tables.CONTRACT_TERMS_DETAIL;

	public ContractTerms getTerm(String schoolId, String termId) {
		return franchiseCtx.selectFrom(CT).where(CT.SCHOOL_ID.eq(schoolId).and(CT.TERM_ID.eq(termId)))
				.fetchAnyInto(ContractTerms.class);
	}

	public List<ContractTerms> mutiGetShowLessonNum(Collection<String> schoolIds, Collection<String> termIds) {
		return franchiseCtx.select(CT.SCHOOL_ID, CT.TERM_ID, CT.SHOW_LESSON_NUM).from(CT)
				.where(CT.SCHOOL_ID.in(schoolIds).and(CT.TERM_ID.in(termIds))).fetchInto(ContractTerms.class);
	}

	public List<ContractTermsDetail> getDetails(String schoolId, String termId) {
		return franchiseCtx.select(CTD.TITLE, CTD.CONTENT).from(CTD)
				.where(CTD.SCHOOL_ID.eq(schoolId).and(CTD.TERM_ID.eq(termId))).orderBy(CTD.SEQ.asc())
				.fetchInto(ContractTermsDetail.class);
	}

}
