package com.jz.jar.franchise.service;

import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.IpAreaBaseRepository;
import com.jz.jooq.franchise.tables.pojos.IpAreaBase;

@Lazy
@Service
public class IpAreaService {

	@Autowired
	private IpAreaBaseRepository ipAreaBaseRepository;

	public String calProvForIp(String ip) {
		String halfIp = this.getHalfIp(ip);
		long code = this.ipToLong(ip);
		String prov = ipAreaBaseRepository.getProv(halfIp, code);
		return prov;
	}

	public Pair<String, String> calProvCityForIp(String ip) {
		String halfIp = this.getHalfIp(ip);
		long code = this.ipToLong(ip);
		IpAreaBase iab = ipAreaBaseRepository.getProvCity(halfIp, code);
		if (iab == null) {
			return null;
		}
		return Pair.of(iab.getProv(), iab.getCity());
	}

	private String getHalfIp(String ip) {
		try {
			String[] ips = ip.split("\\.");
			return Integer.parseInt(ips[0]) + "." + Integer.parseInt(ips[1]);
		} catch (Exception e) {
			return "";
		}
	}

	public long ipToLong(String ip) {
		try {
			String[] ips = ip.split("\\.");
			return (Long.parseLong(ips[0]) << 24) + (Long.parseLong(ips[1]) << 16) + (Long.parseLong(ips[2]) << 8)
					+ Long.parseLong(ips[3]);
		} catch (Exception e) {
			return 0l;
		}
	}
}
