package com.jz.jar.franchise.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.CoursePackRepository;
import com.jz.jar.franchise.wrapper.CoursePackWrapper;
import com.jz.jooq.franchise.tables.pojos.CoursePackSchool;
import com.jz.jooq.franchise.tables.pojos.CoursePackV2;
import com.jz.jooq.franchise.tables.pojos.CoursePackV2HoSchool;

@Lazy
@Service
public class CoursePackService {

	@Autowired
	private CoursePackRepository coursePackRepository;

	public List<Integer> getCoursesByPackId(String brandId, String prov, String city, String schoolId,
			String coursePackId) {
		List<Integer> courseIds = coursePackRepository.getHoCourseIds(brandId, coursePackId);
		if (ArrayMapTools.isEmpty(courseIds)) {
			courseIds = coursePackRepository.getSchoolCourseIds(schoolId, coursePackId);
		}
		return courseIds;
	}

	public CoursePackWrapper getCoursePackWrapper(String brandId, String prov, String city, String schoolId,
			String coursePackId) {
		CoursePackV2 hoPack = coursePackRepository.getCoursePackHo(brandId, coursePackId);
		if (hoPack != null) {
			CoursePackV2HoSchool price = coursePackRepository.getCoursePackCity(schoolId, coursePackId);
			if (price != null) {
				return CoursePackWrapper.of(hoPack, price);
			}
		}
		CoursePackSchool schPack = coursePackRepository.getCoursePackSchool(schoolId, coursePackId);
		if (schPack != null) {
			return CoursePackWrapper.of(schPack);
		} else {
			return null;
		}
	}

}
