package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.StudentInfo;
import com.jz.jooq.franchise.tables.records.StudentInfoRecord;

/**
 * @Title StudentInfoRepository
 * @Package com.jz.jar.franchise.repository
 * @author tangjunfeng
 * @date 2018年8月3日 下午3:17:40
 * @version V1.0
 */
@Lazy
@Repository
public class StudentInfoRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.StudentInfo SI = Tables.STUDENT_INFO;
	private static final com.jz.jooq.franchise.tables.StudentTag ST = Tables.STUDENT_TAG;

	public String getStudentBirthday(String suid) {
		return franchiseCtx.select(SI.BIRTHDAY).from(SI).where(SI.SUID.eq(suid)).fetchAnyInto(String.class);
	}

	public void refreshStudent(String puid, String suid, String cnName, String enName, String sex, String birthday,
			String avatar, String pinyin, String pinyingSimple) {
		StudentInfoRecord student = new StudentInfoRecord();
		student.setSuid(suid);
		student.setPuid(puid);
		student.setName(cnName);
		student.setNamePy(pinyin);
		student.setNamePySimple(pinyingSimple);
		student.setSex(sex);
		student.setBirthday(birthday);
		student.setEngName(enName);
		student.setAvatar(avatar);
		student.setCreated(System.currentTimeMillis());
		franchiseCtx.insertInto(SI).set(student).onDuplicateKeyUpdate().set(SI.NAME, cnName).set(SI.NAME_PY, pinyin)
				.set(SI.NAME_PY_SIMPLE, pinyingSimple).set(SI.SEX, sex).set(SI.BIRTHDAY, birthday)
				.set(SI.ENG_NAME, enName).set(SI.AVATAR, avatar).execute();
	}

	public List<StudentInfo> getStudents(String puid) {
		return franchiseCtx.selectFrom(SI).where(SI.PUID.eq(puid).and(SI.STATUS.eq(1))).fetchInto(StudentInfo.class);
	}

	public List<String> getAllSuidsByPuid(String puid) {
		return franchiseCtx.select(SI.SUID).from(SI).where(SI.PUID.eq(puid)).fetchInto(String.class);
	}

	public List<StudentInfo> getStudentsForPuidAndOtherSuids(String puid, Collection<String> otherSuids) {
		return franchiseCtx.selectFrom(SI).where(SI.SUID.in(otherSuids).or(SI.PUID.eq(puid))).and(SI.STATUS.eq(1))
				.fetchInto(StudentInfo.class);
	}

	public StudentInfo getStudent(String suid) {
		return franchiseCtx.selectFrom(SI).where(SI.SUID.eq(suid)).fetchAnyInto(StudentInfo.class);
	}

	public StudentInfo getSimpleStudentInfo(String suid) {
		return franchiseCtx.select(SI.CODE, SI.PUID, SI.SUID, SI.NAME, SI.BIRTHDAY, SI.ENG_NAME, SI.AVATAR).from(SI)
				.where(SI.SUID.eq(suid)).fetchAnyInto(StudentInfo.class);
	}

	public List<StudentInfo> getSimpleStudentInfo(Collection<String> puids) {
		return franchiseCtx.select(SI.CODE, SI.PUID, SI.SUID, SI.NAME, SI.BIRTHDAY, SI.ENG_NAME, SI.AVATAR).from(SI)
				.where(SI.PUID.in(puids).and(SI.STATUS.eq(1))).orderBy(SI.BIRTHDAY.asc()).fetchInto(StudentInfo.class);
	}

	public List<StudentInfo> getSimpleStudentInfoForSuid(Collection<String> suids) {
		return franchiseCtx.select(SI.CODE, SI.SUID, SI.NAME, SI.BIRTHDAY, SI.ENG_NAME, SI.AVATAR, SI.SEX, SI.PUID)
				.from(SI).where(SI.SUID.in(suids)).fetchInto(StudentInfo.class);
	}

	public Map<String, String> mutiGetSuid2NameMap(Collection<String> suids) {
		return franchiseCtx.select(SI.SUID, SI.NAME).from(SI).where(SI.SUID.in(suids)).fetchMap(SI.SUID, SI.NAME);
	}

	public int getStudentTotalCnt() {
		return franchiseCtx.fetchCount(SI);
	}

	public boolean existCurrentStudent(String puid, String suid) {
		return franchiseCtx.fetchExists(SI, SI.PUID.eq(puid).and(SI.SUID.eq(suid)));
	}

	public Map<String, String> getStudentName(String puid) {
		return franchiseCtx.select(SI.SUID, SI.NAME).from(SI).where(SI.PUID.eq(puid)).fetchMap(SI.SUID, SI.NAME);
	}

	public boolean existStudentName(String puid, String name) {
		return franchiseCtx.fetchExists(SI, SI.PUID.eq(puid).and(SI.NAME.eq(name)));
	}

	public StudentInfo getStudentByPuidName(String puid, String name) {
		return franchiseCtx.selectFrom(SI).where(SI.PUID.eq(puid).and(SI.NAME.eq(name)))
				.fetchAnyInto(StudentInfo.class);
	}

	public void updateStudentStatus(String uid, String suid, int status) {
		franchiseCtx.update(SI).set(SI.STATUS, status).where(SI.SUID.eq(suid).and(SI.PUID.eq(uid))).execute();
	}

	public List<String> getStudentTags(String showSuid, String brand) {
		return franchiseCtx.select(ST.DETAIL_TAG).from(ST).where(ST.SUID.eq(showSuid).and(ST.BRAND_ID.eq(brand)))
				.orderBy(ST.ID.asc()).fetchInto(String.class);
	}
}
