package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.LessonDaka;
import com.jz.jooq.franchise.tables.records.LessonDakaRecord;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class LessonDakaRepository extends FranchiseBaseRepository
		implements FranchiseConditionRepository<LessonDakaRecord> {

	private static final com.jz.jooq.franchise.tables.LessonDaka LD = Tables.LESSON_DAKA;

	public LessonDaka getDakaByLessonId(String schoolId, String lessonId) {
		return franchiseCtx.selectFrom(LD).where(LD.SCHOOL_ID.eq(schoolId).and(LD.LESSON_ID.eq(lessonId)))
				.fetchAnyInto(LessonDaka.class);
	}

	public List<LessonDaka> mutiGetDakaBySchoolIdsLessonIds(Map<String, Collection<String>> schoolId2LessonIds) {
		return franchiseCtx.selectFrom(LD).where(getOrWhereCondition(LD.SCHOOL_ID, LD.LESSON_ID, schoolId2LessonIds))
				.fetchInto(LessonDaka.class);
	}

}
