package com.jz.jar.franchise.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.StudentRelParentRepository;

@Lazy
@Service
public class StudentRelParentService {

	@Autowired
	private StudentRelParentRepository studentRelParentRepository;

	public List<String> getSuidsByRelPuid(String relPuid) {
		return studentRelParentRepository.getSuidsByRelPuid(relPuid);
	}

	public boolean checkSuidRelPuid(String suid, String relPuid) {
		return studentRelParentRepository.checkSuidRelPuid(suid, relPuid);
	}
}
