package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.CourseRepository;
import com.jz.jar.franchise.repository.CourseTomatoRepository;
import com.jz.jar.franchise.wrapper.CourseWrapper;
import com.jz.jooq.franchise.tables.pojos.CourseHo;
import com.jz.jooq.franchise.tables.pojos.CourseHoLesson;
import com.jz.jooq.franchise.tables.pojos.CourseTomato;
import com.jz.jooq.franchise.tables.pojos.Lesson;

@Lazy
@Service
public class CourseService {

	@Autowired
	private CourseRepository courseRepository;
	@Autowired
	private CourseTomatoRepository courseTomatoRepository;
	@Autowired
	private CourseFreeSettingService courseFreeSettingService;
	@Autowired
	private CourseHoLessonService courseHoLessonService;

	/**
	 * 这里不包含具体lesson信息
	 */
	public Map<Integer, CourseWrapper> mutiGetCourseInfoMap(String brandId, Collection<Integer> courseIds) {
		Map<Integer, CourseWrapper> map = Maps.newHashMap();
		List<Integer> officalCourseIds = Lists.newArrayList();
		for (Integer courseId : courseIds) {
			if (courseId < 0) {
				CourseWrapper cw = courseFreeSettingService.getFreeCourseWrapper(brandId, courseId);
				if (cw != null) {
					map.put(courseId, cw);
				}
			} else {
				officalCourseIds.add(courseId);
			}
		}
		if (StringUtils.equals(brandId, "tomato")) {
			List<CourseTomato> hos = courseTomatoRepository.mutiGetCourses(brandId, officalCourseIds);
			if (ArrayMapTools.isNotEmpty(hos)) {
				hos.forEach(it -> {
					map.put(it.getCourseId(), CourseWrapper.ofHo(it));
				});
			}
		} else {
			List<CourseHo> hos = courseRepository.mutiGetHoCourse(brandId, officalCourseIds);
			if (ArrayMapTools.isNotEmpty(hos)) {
				hos.forEach(it -> {
					map.put(it.getCourseId(), CourseWrapper.ofHo(it));
				});
			}
		}
		return map;
	}

	public Map<String, String> mutiCalSchoolSimplePlans(String brandId, List<Lesson> lessonArray) {
		if (ArrayMapTools.isEmpty(lessonArray)) {
			return Maps.newHashMap();
		}
		Map<Integer, Collection<Integer>> course2LessonTimes = Maps.newHashMap();
		for (Lesson l : lessonArray) {
			if (course2LessonTimes.containsKey(l.getCourseId())) {
				course2LessonTimes.get(l.getCourseId()).add(l.getLessonTime());
			} else {
				course2LessonTimes.put(l.getCourseId(), Lists.newArrayList(l.getLessonTime()));
			}
		}
		List<CourseHoLesson> titles = courseHoLessonService.findSimpleHoLession(brandId, course2LessonTimes);
		Map<Integer, Map<Integer, String>> courseId2LessonTime2Title = Maps.newHashMap();
		for (CourseHoLesson t : titles) {
			if (!courseId2LessonTime2Title.containsKey(t.getCourseId())) {
				courseId2LessonTime2Title.put(t.getCourseId(), Maps.newHashMap());
			}
			courseId2LessonTime2Title.get(t.getCourseId()).put(t.getLessonTime(), t.getLessonTitle());
		}
		Map<String, String> lessonId2TitleMap = Maps.newHashMap();
		for (Lesson l : lessonArray) {
			Map<Integer, String> lessonTime2title = courseId2LessonTime2Title.get(l.getCourseId());
			if (lessonTime2title != null && lessonTime2title.containsKey(l.getLessonTime())) {
				lessonId2TitleMap.put(l.getLessonId(), lessonTime2title.get(l.getLessonTime()));
			}
		}
		return lessonId2TitleMap;
	}

}
