package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.ArtAlbumInfo;
import com.jz.jooq.franchise.tables.pojos.ArtAlbumOrder;

/**
 * 画册
 */
@Lazy
@Repository
public class ArtAlbumRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.ArtAlbumInfo AAI = Tables.ART_ALBUM_INFO;
	private static final com.jz.jooq.franchise.tables.ArtAlbumOrder AAO = Tables.ART_ALBUM_ORDER;

	/** ArtAlbumInfo **/
	public ArtAlbumInfo getInfo(String albumId) {
		return franchiseCtx.selectFrom(AAI).where(AAI.ALBUM_ID.eq(albumId)).fetchAnyInto(ArtAlbumInfo.class);
	}

	public String getAlbumName(String albumId) {
		return franchiseCtx.select(AAI.NAME).from(AAI).where(AAI.ALBUM_ID.eq(albumId)).fetchAnyInto(String.class);
	}

	public List<ArtAlbumInfo> mutiGetInfos(Collection<String> albumIds) {
		return franchiseCtx.selectFrom(AAI).where(AAI.ALBUM_ID.in(albumIds)).fetchInto(ArtAlbumInfo.class);
	}

	public Map<String, String> mutiGetAlbumId2NameMap(Collection<String> albumIds) {
		return franchiseCtx.select(AAI.ALBUM_ID, AAI.NAME).from(AAI).where(AAI.ALBUM_ID.in(albumIds))
				.fetchMap(AAI.ALBUM_ID, AAI.NAME);
	}

	/** ArtAlbumOrder **/
	public List<ArtAlbumOrder> mutiGetOrdersByArtIds(Collection<String> artIds) {
		return franchiseCtx.selectFrom(AAO).where(AAO.ART_ID.in(artIds).and(AAO.STATUS.eq(1)))
				.fetchInto(ArtAlbumOrder.class);
	}

	public List<ArtAlbumOrder> getArtAlbumOrderBySuid(String suid) {
		return franchiseCtx.selectFrom(AAO).where(AAO.SUID.eq(suid).and(AAO.STATUS.eq(1)))
				.fetchInto(ArtAlbumOrder.class);
	}

	public List<ArtAlbumOrder> getArtAlbumOrderBySuids(Collection<String> suids) {
		return franchiseCtx.selectFrom(AAO).where(AAO.SUID.in(suids).and(AAO.STATUS.eq(1)))
				.fetchInto(ArtAlbumOrder.class);
	}

}
