package com.jz.jar.franchise.repository;

import java.util.List;

import org.apache.commons.lang3.tuple.Pair;
import org.jooq.Condition;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.AppraiseSetting;

@Lazy
@Repository
public class AppraiseSettingRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.AppraiseSetting A = Tables.APPRAISE_SETTING;

	public List<AppraiseSetting> findAppraiseInfo(String level, List<Pair<Integer, String>> starCnt2Name) {
		List<Condition> ors = Lists.newArrayList();
		for (Pair<Integer, String> p : starCnt2Name) {
			ors.add(A.STAR_CNT.eq(p.getLeft()).and(A.NAME.eq(p.getRight())));
		}
		return franchiseCtx.selectFrom(A).where(A.LEVEL.eq(level).and(DSL.or(ors))).orderBy(A.SEQ)
				.fetchInto(AppraiseSetting.class);
	}

	public List<AppraiseSetting> listAppraiseByLevel(String level) {
		return franchiseCtx.selectFrom(A).where(A.LEVEL.eq(level)).orderBy(A.SEQ).fetchInto(AppraiseSetting.class);
	}

}
