/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.ActivityHo;
import com.jz.jooq.franchise.tables.ActivityHoSchool;
import com.jz.jooq.franchise.tables.pojos.ActivityTemplateArtCommon;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class ActivityHoRepository
extends FranchiseBaseRepository {
    private static final ActivityHo A = Tables.ACTIVITY_HO;
    private static final com.jz.jooq.franchise.tables.ActivityTemplateArtCommon ATAC = Tables.ACTIVITY_TEMPLATE_ART_COMMON;
    private static final ActivityHoSchool AHS = Tables.ACTIVITY_HO_SCHOOL;

    private Condition getWhereCondition(String brandId) {
        return ActivityHoRepository.A.BRAND_ID.eq((Object)brandId).and(ActivityHoRepository.A.APPLY_STATUS.eq((Object)1)).and(ActivityHoRepository.A.PIC.ne((Object)""));
    }

    public int countOnlineActivities(String brandId) {
        return this.franchiseCtx.fetchCount((Table)A, this.getWhereCondition(brandId));
    }

    public List<com.jz.jooq.franchise.tables.pojos.ActivityHo> findAllOnlineActivities(String brandId, int start, int size) {
        long timeMillis = System.currentTimeMillis();
        Field orderField = DSL.choose().when(ActivityHoRepository.A.START_TIME.le((Object)timeMillis).and(ActivityHoRepository.A.END_TIME.ge((Object)timeMillis)), DSL.zero()).when(ActivityHoRepository.A.START_TIME.gt((Object)timeMillis), DSL.one()).otherwise(DSL.two()).as("COT");
        return this.franchiseCtx.select((SelectField)ActivityHoRepository.A.NAME, (SelectField)ActivityHoRepository.A.START_TIME, (SelectField)ActivityHoRepository.A.END_TIME, (SelectField)ActivityHoRepository.A.DESCRIPTION, (SelectField)ActivityHoRepository.A.PIC, (SelectField)ActivityHoRepository.A.DISPLAY_URL, (SelectField)orderField).from((TableLike)A).where(new Condition[]{this.getWhereCondition(brandId)}).orderBy(orderField.asc(), ActivityHoRepository.A.START_TIME.asc()).limit(start, size).fetchInto(com.jz.jooq.franchise.tables.pojos.ActivityHo.class);
    }

    public Map<String, String> mutiGetActivityId2NameMap(Collection<String> activityIds) {
        return this.franchiseCtx.select((SelectField)ActivityHoRepository.A.ACTIVITY_ID, (SelectField)ActivityHoRepository.A.NAME).from((TableLike)A).where(new Condition[]{ActivityHoRepository.A.ACTIVITY_ID.in(activityIds)}).fetchMap((Field)ActivityHoRepository.A.ACTIVITY_ID, (Field)ActivityHoRepository.A.NAME);
    }

    public String getActivityName(String activityId) {
        return (String)this.franchiseCtx.select((SelectField)ActivityHoRepository.A.NAME).from((TableLike)A).where(new Condition[]{ActivityHoRepository.A.ACTIVITY_ID.eq((Object)activityId)}).fetchAnyInto(String.class);
    }

    public List<com.jz.jooq.franchise.tables.pojos.ActivityHo> mutiGetSimpleActivityHo(Collection<String> allowActivityIds) {
        return this.franchiseCtx.select((SelectField)ActivityHoRepository.A.ACTIVITY_ID, (SelectField)ActivityHoRepository.A.NAME, (SelectField)ActivityHoRepository.A.PIC).from((TableLike)A).where(new Condition[]{ActivityHoRepository.A.ACTIVITY_ID.in(allowActivityIds)}).fetchInto(com.jz.jooq.franchise.tables.pojos.ActivityHo.class);
    }

    public List<ActivityTemplateArtCommon> getPublishExcludeNoStartTemplate(String brandId, int size) {
        return this.franchiseCtx.selectFrom((Table)ATAC).where(new Condition[]{ActivityHoRepository.ATAC.BRAND_ID.eq((Object)brandId).and(ActivityHoRepository.ATAC.STATUS.eq((Object)1)).and(ActivityHoRepository.ATAC.START_TIME.lt((Object)System.currentTimeMillis()))}).orderBy(ActivityHoRepository.ATAC.START_TIME.desc()).limit(size).fetchInto(ActivityTemplateArtCommon.class);
    }

    public List<ActivityTemplateArtCommon> getCurrentPublishTemplate(String brandId, int size) {
        long current = System.currentTimeMillis();
        return this.franchiseCtx.selectFrom((Table)ATAC).where(new Condition[]{ActivityHoRepository.ATAC.BRAND_ID.eq((Object)brandId).and(ActivityHoRepository.ATAC.END_TIME.gt((Object)current)).and(ActivityHoRepository.ATAC.START_TIME.lt((Object)current)).and(ActivityHoRepository.ATAC.STATUS.eq((Object)1))}).orderBy(ActivityHoRepository.ATAC.START_TIME.desc()).limit(size).fetchInto(ActivityTemplateArtCommon.class);
    }

    public boolean existCurrentPublishAllowWorksTemplate(String brandId) {
        long current = System.currentTimeMillis();
        return this.franchiseCtx.fetchExists((Table)ATAC, ActivityHoRepository.ATAC.BRAND_ID.eq((Object)brandId).and(ActivityHoRepository.ATAC.SIGN_END_TIME.gt((Object)current)).and(ActivityHoRepository.ATAC.START_TIME.lt((Object)current)).and(ActivityHoRepository.ATAC.STATUS.eq((Object)1)).and(ActivityHoRepository.ATAC.ALLOW_WORKS.eq((Object)1)));
    }

    public Map<String, BigDecimal> mutiGetActivityIdPaperCertFee(Collection<String> activityIds) {
        return this.franchiseCtx.select((SelectField)ActivityHoRepository.ATAC.ACTIVITY_ID, (SelectField)ActivityHoRepository.ATAC.AWARD_PIC_FEE).from((TableLike)ATAC).where(new Condition[]{ActivityHoRepository.ATAC.ACTIVITY_ID.in(activityIds)}).fetchMap((Field)ActivityHoRepository.ATAC.ACTIVITY_ID, (Field)ActivityHoRepository.ATAC.AWARD_PIC_FEE);
    }

    public BigDecimal getPaperCertFee(String activityId) {
        return (BigDecimal)this.franchiseCtx.select((SelectField)ActivityHoRepository.ATAC.AWARD_PIC_FEE).from((TableLike)ATAC).where(new Condition[]{ActivityHoRepository.ATAC.ACTIVITY_ID.eq((Object)activityId)}).fetchAnyInto(BigDecimal.class);
    }

    public List<String> getSchoolSignedActivityIds(String schoolId, Collection<String> activityIds) {
        return this.franchiseCtx.select((SelectField)ActivityHoRepository.AHS.ACTIVITY_ID).from((TableLike)AHS).where(new Condition[]{ActivityHoRepository.AHS.ACTIVITY_ID.in(activityIds).and(ActivityHoRepository.AHS.SCHOOL_ID.eq((Object)schoolId)).and(ActivityHoRepository.AHS.STATUS.eq((Object)1))}).fetchInto(String.class);
    }

    public List<ActivityTemplateArtCommon> mutiGetActivityTemplate(Collection<String> activityIds) {
        return this.franchiseCtx.selectFrom((Table)ATAC).where(new Condition[]{ActivityHoRepository.ATAC.ACTIVITY_ID.in(activityIds)}).fetchInto(ActivityTemplateArtCommon.class);
    }
}

