package com.jz.jar.franchise.service;

import java.util.List;
import java.util.Map;

import javax.annotation.PostConstruct;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.CourseFreeSettingRepository;
import com.jz.jar.franchise.wrapper.CourseWrapper;
import com.jz.jooq.franchise.tables.pojos.CourseFreeSetting;

@Lazy
@Service
@EnableScheduling
public class CourseFreeSettingService {

	private Logger logger = LoggerFactory.getLogger(CourseFreeSettingService.class);

	@Autowired
	private CourseFreeSettingRepository courseFreeSettingRepository;

	private Map<String, Map<Integer, CourseFreeSetting>> brandMap = Maps.newHashMap();

	@PostConstruct
	public void run() throws Exception {
		logger.warn("CourseFreeSettingService start...");
		fresh();
		logger.warn("CourseFreeSettingService end...");
	}

	@Scheduled(cron = "0 */5 * * * ?")
	public void fresh() {
		List<CourseFreeSetting> settings = courseFreeSettingRepository.listFreeSetting();
		if (ArrayMapTools.isNotEmpty(settings)) {
			Map<String, Map<Integer, CourseFreeSetting>> brandMapTemp = Maps.newHashMap();
			for (CourseFreeSetting setting : settings) {
				if (!brandMapTemp.containsKey(setting.getBrandId())) {
					brandMapTemp.put(setting.getBrandId(), Maps.newLinkedHashMap());
				}
				brandMapTemp.get(setting.getBrandId()).put(setting.getCourseId(), setting);

			}
			brandMap = brandMapTemp;
			logger.warn("brandMap.size:" + brandMap.size());
		}
	}

	public CourseWrapper getFreeCourseWrapper(String brandId, int courseId) {
		if (!brandMap.containsKey(brandId)) {
			return null;
		}
		Map<Integer, CourseFreeSetting> courseMap = brandMap.get(brandId);
		if (courseMap.containsKey(courseId)) {
			CourseFreeSetting setting = courseMap.get(courseId);
			return CourseWrapper.ofFree(setting.getCourseId(), setting.getCourseName(), setting.getLessonNum());
		} else {
			return null;
		}
	}

	public List<CourseWrapper> getFreeCourses(String brandId) {
		if (!brandMap.containsKey(brandId)) {
			return null;
		}
		List<CourseWrapper> list = Lists.newArrayList();
		for (CourseFreeSetting setting : brandMap.get(brandId).values()) {
			list.add(CourseWrapper.ofFree(setting.getCourseId(), setting.getCourseName(), setting.getLessonNum()));
		}
		return list;
	}

	public CourseFreeSetting getFreeCourseForBrand(String brandId, int courseId) {
		if (!brandMap.containsKey(brandId) || !brandMap.get(brandId).containsKey(courseId)) {
			return null;
		}
		return brandMap.get(brandId).get(courseId);
	}
}
