package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.ArtAlbumRepository;
import com.jz.jooq.franchise.tables.pojos.ArtAlbumInfo;
import com.jz.jooq.franchise.tables.pojos.ArtAlbumOrder;

@Lazy
@Service
public class ArtAlbumService {

	@Autowired
	private ArtAlbumRepository artAlbumRepository;

	public ArtAlbumInfo getInfo(String albumId) {
		return artAlbumRepository.getInfo(albumId);
	}

	public String getAlbumName(String albumId) {
		return artAlbumRepository.getAlbumName(albumId);
	}

	public List<ArtAlbumInfo> mutiGetInfos(Collection<String> albumIds) {
		return artAlbumRepository.mutiGetInfos(albumIds);
	}

	public Map<String, String> mutiGetAlbumId2NameMap(Collection<String> albumIds) {
		return artAlbumRepository.mutiGetAlbumId2NameMap(albumIds);
	}

	public List<ArtAlbumOrder> mutiGetOrdersByArtIds(Collection<String> artIds) {
		return artAlbumRepository.mutiGetOrdersByArtIds(artIds);
	}

	public List<ArtAlbumOrder> getArtAlbumOrderBySuid(String suid) {
		return artAlbumRepository.getArtAlbumOrderBySuid(suid);
	}

	public List<ArtAlbumOrder> getArtAlbumOrderBySuids(Collection<String> suids) {
		return artAlbumRepository.getArtAlbumOrderBySuids(suids);
	}
}
