package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.StudentSchool;

@Lazy
@Repository
public class StudentSchoolRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.StudentSchool SS = Tables.STUDENT_SCHOOL;

	public boolean isContainsSchool(String suid) {
		return franchiseCtx.fetchExists(SS, SS.SUID.eq(suid).and(SS.HAVE_CONTRACT.eq(1)));
	}

	public List<String> getContainsSchool(Collection<String> suidArray) {
		return franchiseCtx.select(SS.SUID).from(SS).where(SS.SUID.in(suidArray).and(SS.HAVE_CONTRACT.eq(1)))
				.fetchInto(String.class);
	}

	public Long getFirstContractTime(String suid, String schoolId) {
		return franchiseCtx.select(SS.FIRST_CONTRACT_TIME).from(SS)
				.where(SS.SUID.eq(suid).and(SS.SCHOOL_ID.eq(schoolId))).fetchAnyInto(Long.class);
	}

	public StudentSchool getStopTime(String suid, Collection<String> schoolIds) {
		long timeMillis = System.currentTimeMillis();
		return franchiseCtx.select(SS.STOP_START_TIME, SS.STOP_END_TIME).from(SS)
				.where(SS.SUID.eq(suid).and(SS.SCHOOL_ID.in(schoolIds)).and(SS.HAVE_CONTRACT.eq(1))
						.and(SS.STOP_START_TIME.le(timeMillis)).and(SS.STOP_END_TIME.gt(timeMillis)))
				.orderBy(SS.STOP_START_TIME.asc()).fetchAnyInto(StudentSchool.class);
	}

	public List<String> getReadingSchoolIds(String suid) {
		return franchiseCtx.select(SS.SCHOOL_ID).from(SS)
				.where(SS.SUID.eq(suid).and(SS.HAVE_CONTRACT.eq(1)).and(SS.STATUS.notEqual(10)))
				.fetchInto(String.class);
	}

	public List<String> getHaveContractSchoolIds(String suid) {
		return franchiseCtx.select(SS.SCHOOL_ID).from(SS).where(SS.SUID.eq(suid).and(SS.HAVE_CONTRACT.equal(1)))
				.orderBy(SS.STATUS.asc()).fetchInto(String.class);
	}

	public StudentSchool getStudentSchool(String suid, String schoolId) {
		return franchiseCtx.selectFrom(SS).where(SS.SUID.eq(suid).and(SS.SCHOOL_ID.eq(schoolId)))
				.fetchAnyInto(StudentSchool.class);
	}

	public Integer getStudentCurrentLevel(String suid, String schoolId) {
		return franchiseCtx.select(SS.CURRENT_LEVEL).from(SS).where(SS.SUID.eq(suid).and(SS.SCHOOL_ID.eq(schoolId)))
				.fetchAnyInto(Integer.class);
	}
}
