package com.jz.jar.franchise.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.alibaba.fastjson.JSON;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.wrapper.CaseChildWrapper;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.MarketCasePool;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class MarketCasePoolRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.MarketCasePool MCP = Tables.MARKET_CASE_POOL;
	private static final com.jz.jooq.franchise.tables.MarketCaseCommunicateRecord MCCR = Tables.MARKET_CASE_COMMUNICATE_RECORD;

	public MarketCasePool getMarketCaseById(String caseId, String schoolId) {
		return franchiseCtx.selectFrom(MCP).where(MCP.ID.eq(caseId).and(MCP.SCHOOL_ID.eq(schoolId)))
				.fetchAnyInto(MarketCasePool.class);
	}

	public MarketCasePool getMarketCaseByPhone(String schoolId, String phone) {
		return franchiseCtx.selectFrom(MCP).where(MCP.SCHOOL_ID.eq(schoolId).and(MCP.PHONE.eq(phone)))
				.fetchAnyInto(MarketCasePool.class);
	}

	public MarketCasePool getMarketCaseByPuid(String schoolId, String puid) {
		return franchiseCtx.selectFrom(MCP).where(MCP.SCHOOL_ID.eq(schoolId).and(MCP.PUID.eq(puid)))
				.fetchAnyInto(MarketCasePool.class);
	}

	public void createCase(String caseId, String uid, String schoolId, String channelId, String phone, String wechat,
			String qq, List<CaseChildWrapper> childs, String childPy, String parentName, String relation,
			String address, String district, String level, long nextCommunicateTime) {
		long timeMillis = System.currentTimeMillis();
		franchiseCtx
				.insertInto(MCP, MCP.ID, MCP.SCHOOL_ID, MCP.PHONE, MCP.WECHAT, MCP.QQ, MCP.PARENT_NAME, MCP.CHILD_INFO,
						MCP.CHILD_PY, MCP.RELATION, MCP.ADDRESS, MCP.DISTRICT, MCP.LEVEL, MCP.CHANNEL_ID, MCP.CREATED,
						MCP.LAST_CREATED, MCP.CREATE_USER, MCP.NEXT_COMMUNICATE_TIME)
				.values(caseId, schoolId, phone, wechat, qq, parentName,
						ArrayMapTools.isNotEmpty(childs) ? JSON.toJSONString(childs) : "", childPy, relation, address,
						district, level, channelId, timeMillis, timeMillis, uid, nextCommunicateTime).execute();
	}

	public void updateLastCreatedAndCreateNumForCurrent(String caseId) {
		franchiseCtx.update(MCP).set(MCP.LAST_CREATED, System.currentTimeMillis())
				.set(MCP.CREATE_NUM, MCP.CREATE_NUM.add(1)).where(MCP.ID.eq(caseId)).execute();
	}

	public void updateCaseLevel(String schoolId, String caseId, String level) {
		franchiseCtx.update(MCP).set(MCP.LEVEL, level).where(MCP.ID.eq(caseId)).and(MCP.SCHOOL_ID.eq(schoolId))
				.execute();
	}

	public void createCommunicateRecord(String schoolId, String caseId, String uid, String operRecord,
			String communicateRs, String level, int effect) {
		franchiseCtx
				.insertInto(MCCR, MCCR.SCHOOL_ID, MCCR.CASE_ID, MCCR.UID, MCCR.OPER_RECORD, MCCR.COMMUNICATE_RS,
						MCCR.LEVEL, MCCR.EFFECT, MCCR.CREATED)
				.values(schoolId, caseId, uid, operRecord, communicateRs, level, effect, System.currentTimeMillis())
				.execute();
	}

}
