/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jar.franchise.repository.FranchiseConditionRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.ClassStudent;
import com.jz.jooq.franchise.tables.records.ClassStudentRecord;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class ClassStudentRepository
extends FranchiseBaseRepository
implements FranchiseConditionRepository<ClassStudentRecord> {
    private static final ClassStudent CS = Tables.CLASS_STUDENT;

    public List<com.jz.jooq.franchise.tables.pojos.ClassStudent> findClassStudent(String suid, Map<String, Collection<String>> school2ClassId) {
        Condition condition = this.getOrWhereCondition(ClassStudentRepository.CS.SCHOOL_ID, ClassStudentRepository.CS.CID, school2ClassId).and(ClassStudentRepository.CS.SUID.eq((Object)suid));
        condition = condition.and(DSL.or((Condition[])new Condition[]{ClassStudentRepository.CS.END_TIME.isNull(), ClassStudentRepository.CS.END_TIME.gt((Object)System.currentTimeMillis())}));
        return this.franchiseCtx.select((SelectField)ClassStudentRepository.CS.SCHOOL_ID, (SelectField)ClassStudentRepository.CS.CID, (SelectField)ClassStudentRepository.CS.CONTRACT_ID).from((TableLike)CS).where(new Condition[]{condition}).fetchInto(com.jz.jooq.franchise.tables.pojos.ClassStudent.class);
    }

    public String getContract(String suid, String school, String classId) {
        Condition condition = ClassStudentRepository.CS.SCHOOL_ID.eq((Object)school).and(ClassStudentRepository.CS.CID.eq((Object)classId)).and(ClassStudentRepository.CS.SUID.eq((Object)suid));
        condition = condition.and(DSL.or((Condition[])new Condition[]{ClassStudentRepository.CS.END_TIME.isNull(), ClassStudentRepository.CS.END_TIME.gt((Object)System.currentTimeMillis())}));
        List list = this.franchiseCtx.select((SelectField)ClassStudentRepository.CS.CONTRACT_ID).from((TableLike)CS).where(new Condition[]{condition}).fetchInto(String.class);
        return ArrayMapTools.isNotEmpty((Collection)list) ? (String)list.get(0) : null;
    }
}

