package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.ActivityArt;
import com.jz.jooq.franchise.tables.pojos.ActivityArtAward;
import com.jz.jooq.franchise.tables.pojos.ActivityArtOtherAuthor;
import com.jz.jooq.franchise.tables.pojos.ActivityArtThanks;
import com.jz.jooq.franchise.tables.pojos.ActivityOciTeamMember;

@Lazy
@Repository
public class ActivityArtRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.ActivityArt AA = Tables.ACTIVITY_ART;
	private static final com.jz.jooq.franchise.tables.ActivityArtAward AAA = Tables.ACTIVITY_ART_AWARD;
	private static final com.jz.jooq.franchise.tables.ActivityArtOtherAuthor AAOA = Tables.ACTIVITY_ART_OTHER_AUTHOR;
	private static final com.jz.jooq.franchise.tables.ActivityArtThanks AAT = Tables.ACTIVITY_ART_THANKS;
	private static final com.jz.jooq.franchise.tables.ActivityOciTeamMember AOTM = Tables.ACTIVITY_OCI_TEAM_MEMBER;
	private static final com.jz.jooq.franchise.tables.ActivityOciTeam AOT = Tables.ACTIVITY_OCI_TEAM;

	public List<ActivityArt> getAllSimpleArtBySuid(String suid) {
		return franchiseCtx.select(AA.ID, AA.ACTIVITY_ID, AA.SUID).from(AA).where(AA.SUID.eq(suid).and(AA.STATUS.eq(1)))
				.fetchInto(ActivityArt.class);
	}

	public List<ActivityArt> getAllArtByPuid(String puid) {
		return franchiseCtx.selectFrom(AA).where(AA.PUID.eq(puid).and(AA.STATUS.eq(1))).orderBy(AA.CREATE_TIME.desc())
				.fetchInto(ActivityArt.class);
	}

	public List<ActivityArt> mutiGetOnlineArtByArtIds(Collection<String> artIds) {
		return franchiseCtx.selectFrom(AA).where(AA.ID.in(artIds).and(AA.STATUS.eq(1))).fetchInto(ActivityArt.class);
	}

	public List<ActivityArtAward> getArtAwardsByArtIds(Collection<String> artIds) {
		return franchiseCtx.selectFrom(AAA).where(AAA.ART_ID.in(artIds).and(AAA.STATUS.eq(1)))
				.fetchInto(ActivityArtAward.class);
	}

	public ActivityArtAward getArtAwardsByArtId(String artId) {
		return franchiseCtx.selectFrom(AAA).where(AAA.ART_ID.eq(artId).and(AAA.STATUS.eq(1)))
				.fetchAnyInto(ActivityArtAward.class);
	}

	public List<ActivityArtOtherAuthor> getOtherAuthorBySuid(String suid) {
		return franchiseCtx.selectFrom(AAOA).where(AAOA.SUID.eq(suid)).fetchInto(ActivityArtOtherAuthor.class);
	}

	public List<ActivityArtOtherAuthor> getOtherAuthorByPuid(String puid) {
		return franchiseCtx.selectFrom(AAOA).where(AAOA.PUID.eq(puid)).fetchInto(ActivityArtOtherAuthor.class);
	}

	public List<String> getOtherAuthorArtIdsByPuid(String puid) {
		return franchiseCtx.select(AAOA.ART_ID).from(AAOA).where(AAOA.PUID.eq(puid)).fetchInto(String.class);
	}

	public List<ActivityArtThanks> getArtThanksBySuid(String suid) {
		return franchiseCtx.selectFrom(AAT).where(AAT.SUID.eq(suid)).fetchInto(ActivityArtThanks.class);
	}

	public List<ActivityOciTeamMember> getOciTeamMembersBySuid(String suid) {
		return franchiseCtx.selectFrom(AOTM).where(AOTM.SUID.eq(suid).and(AOTM.STATUS.eq(1)))
				.fetchInto(ActivityOciTeamMember.class);
	}

	public Map<String, String> mutiGetOciTeamId2CertNameMap(Collection<String> teamIds) {
		return franchiseCtx.select(AOT.ID, AOT.CERT_NAME).from(AOT).where(AOT.ID.in(teamIds)).fetchMap(AOT.ID,
				AOT.CERT_NAME);
	}

	public String getOciCertNameByTeamId(String teamId) {
		return franchiseCtx.select(AOT.CERT_NAME).from(AOT).where(AOT.ID.eq(teamId)).fetchAnyInto(String.class);
	}

}
