package com.jz.jar.franchise.repository;

import java.util.Collection;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.records.FuserFlowNoticeRecord;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class FUserFlowNoticeRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.FuserFlowNotice FFN = Tables.FUSER_FLOW_NOTICE;

	public void createNotice(String uid, String schoolId, String type, String content, String dataId) {
		franchiseCtx
				.insertInto(FFN, FFN.FUID, FFN.SCHOOL_ID, FFN.TYPE, FFN.CONTENT, FFN.DATA_ID, FFN.CREATE_TIME, FFN.READ)
				.values(uid, schoolId, type, content, dataId, System.currentTimeMillis(), 0).execute();
	}

	public void mutiCreateNotice(Collection<FuserFlowNoticeRecord> records) {
		franchiseCtx.batchInsert(records).execute();
	}
}
